/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey;

import com.sun.grizzly.SSLConfig;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.zookeeper.server.jersey.ZooKeeperService;
import org.apache.zookeeper.server.jersey.cfg.Credentials;
import org.apache.zookeeper.server.jersey.cfg.Endpoint;
import org.apache.zookeeper.server.jersey.cfg.RestCfg;
import org.apache.zookeeper.server.jersey.filters.HTTPBasicAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestMain {
    private static Logger LOG = LoggerFactory.getLogger(RestMain.class);
    private GrizzlyWebServer gws;
    private RestCfg cfg;

    public RestMain(RestCfg cfg) {
        this.cfg = cfg;
    }

    public void start() throws IOException {
        System.out.println("Starting grizzly ...");
        boolean useSSL = this.cfg.useSSL();
        this.gws = new GrizzlyWebServer(this.cfg.getPort(), "/tmp/23cxv45345/2131xc2/", useSSL);
        for (Endpoint e : this.cfg.getEndpoints()) {
            ZooKeeperService.mapContext(e.getContext(), e);
            this.gws.addGrizzlyAdapter((GrizzlyAdapter)this.createJerseyAdapter(e), new String[]{e.getContext()});
        }
        if (useSSL) {
            System.out.println("Starting SSL ...");
            String jks = this.cfg.getJKS("keys/rest.jks");
            String jksPassword = this.cfg.getJKSPassword();
            SSLConfig sslConfig = new SSLConfig();
            URL resource = this.getClass().getClassLoader().getResource(jks);
            if (resource == null) {
                LOG.error("Unable to find the keystore file: " + jks);
                System.exit(2);
            }
            try {
                sslConfig.setKeyStoreFile(new File(resource.toURI()).getAbsolutePath());
            }
            catch (URISyntaxException e1) {
                LOG.error("Unable to load keystore: " + jks, (Throwable)e1);
                System.exit(2);
            }
            sslConfig.setKeyStorePass(jksPassword);
            this.gws.setSSLConfig(sslConfig);
        }
        this.gws.start();
    }

    public void stop() {
        this.gws.stop();
        ZooKeeperService.closeAll();
    }

    private ServletAdapter createJerseyAdapter(Endpoint e) {
        ServletAdapter jersey = new ServletAdapter();
        jersey.setServletInstance((Servlet)new ServletContainer());
        jersey.addInitParameter("com.sun.jersey.config.property.packages", "org.apache.zookeeper.server.jersey.resources");
        jersey.setContextPath(e.getContext());
        Credentials c = Credentials.join(e.getCredentials(), this.cfg.getCredentials());
        if (!c.isEmpty()) {
            jersey.addFilter((Filter)new HTTPBasicAuth(c), e.getContext() + "-basic-auth", null);
        }
        return jersey;
    }

    public static void main(String[] args) throws Exception {
        RestCfg cfg = new RestCfg("rest.properties");
        final RestMain main = new RestMain(cfg);
        main.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                main.stop();
                System.out.println("Got exit request. Bye.");
            }
        });
        RestMain.printEndpoints(cfg);
        System.out.println("Server started.");
    }

    private static void printEndpoints(RestCfg cfg) {
        int port = cfg.getPort();
        for (Endpoint e : cfg.getEndpoints()) {
            String context = e.getContext();
            if (context.charAt(context.length() - 1) != '/') {
                context = context + "/";
            }
            System.out.println(String.format("Started %s - WADL: http://localhost:%d%sapplication.wadl", context, port, context));
        }
    }
}

