/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate.test;

import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.xml.sax.AbstractLexicalHandler;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Compare {
    public static boolean compare(File file, File file2, SAXResolver sAXResolver) throws SAXException, IOException {
        return Compare.load(sAXResolver, file).equals(Compare.load(sAXResolver, file2));
    }

    private static List<Event> load(SAXResolver sAXResolver, File file) throws SAXException, IOException {
        InputSource inputSource = new InputSource(UriOrFile.fileToUri(file));
        Saver saver = new Saver();
        XMLReader xMLReader = sAXResolver.createXMLReader();
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new SAXException("support for namespaces-prefixes feature required");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new SAXException("support for namespaces-prefixes feature required");
        }
        xMLReader.setContentHandler(saver);
        try {
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", new CommentSaver(saver));
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        xMLReader.parse(inputSource);
        return saver.getEventList();
    }

    public static void main(String[] stringArray) throws SAXException, IOException {
        System.err.println(Compare.compare(new File(stringArray[0]), new File(stringArray[1]), new SAXResolver()));
    }

    static class Saver
    extends DefaultHandler {
        private final List<Event> eventList = new Vector<Event>();
        private final List<Attribute> attributeList = new Vector<Attribute>();

        Saver() {
        }

        List<Event> getEventList() {
            return this.eventList;
        }

        void flushWhitespace(boolean bl) {
            int n = this.eventList.size();
            if (n == 0) {
                return;
            }
            if (!this.eventList.get(n - 1).isWhitespace()) {
                return;
            }
            if (bl && n > 1 && this.eventList.get(n - 2) instanceof StartElement) {
                return;
            }
            this.eventList.remove(n - 1);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.flushWhitespace(false);
            this.eventList.add(new StartElement(string3));
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.attributeList.add(new Attribute(attributes.getQName(i), attributes.getValue(i)));
            }
            Collections.sort(this.attributeList, new Comparator<Attribute>(){

                @Override
                public int compare(Attribute attribute, Attribute attribute2) {
                    return attribute.getQName().compareTo(attribute2.getQName());
                }
            });
            this.eventList.addAll(this.attributeList);
            this.attributeList.clear();
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.flushWhitespace(true);
            this.eventList.add(new EndElement());
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            int n3 = this.eventList.size();
            if (n3 == 0 || !this.eventList.get(n3 - 1).merge(cArray, n, n2)) {
                this.eventList.add(new Text(new String(cArray, n, n2)));
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            this.characters(cArray, n, n2);
        }

        @Override
        public void endDocument() {
            this.flushWhitespace(false);
        }

        void comment(String string) {
            this.flushWhitespace(false);
            this.eventList.add(new Comment(string));
        }
    }

    static class CommentSaver
    extends AbstractLexicalHandler {
        private final Saver saver;

        CommentSaver(Saver saver) {
            this.saver = saver;
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            this.saver.comment(new String(cArray, n, n2));
        }
    }

    static class Text
    extends Event {
        private String value;

        Text(String string) {
            this.value = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Text)) {
                return false;
            }
            return this.value.equals(((Text)object).value);
        }

        @Override
        boolean isWhitespace() {
            int n = this.value.length();
            block3: for (int i = 0; i < n; ++i) {
                switch (this.value.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        boolean merge(char[] cArray, int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer(this.value);
            stringBuffer.append(cArray, n, n2);
            this.value = stringBuffer.toString();
            return true;
        }
    }

    static class Comment
    extends Event {
        private final String value;

        Comment(String string) {
            this.value = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Comment)) {
                return false;
            }
            return this.value.equals(((Comment)object).value);
        }
    }

    private static class EndElement
    extends Event {
        private EndElement() {
        }

        public boolean equals(Object object) {
            return object instanceof EndElement;
        }
    }

    static class Attribute
    extends Event {
        private final String qName;
        private final String value;

        Attribute(String string, String string2) {
            this.qName = string;
            this.value = string2;
        }

        String getQName() {
            return this.qName;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            return this.qName.equals(attribute.qName) && this.value.equals(attribute.value);
        }
    }

    static class StartElement
    extends Event {
        private final String qName;

        StartElement(String string) {
            this.qName = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StartElement)) {
                return false;
            }
            return this.qName.equals(((StartElement)object).qName);
        }
    }

    static abstract class Event {
        Event() {
        }

        boolean merge(char[] cArray, int n, int n2) {
            return false;
        }

        boolean isWhitespace() {
            return false;
        }
    }
}

