/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.prefs.RefactoringPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.refactoring.prefs.RefactoringPreferencesManager;

public class RefactoringPreferencesPanel
extends JPanel {
    private static final long serialVersionUID = -4293776729533111287L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RefactoringPreferencesPanel.class);
    private static final ILogger log = LoggerController.createLogger(RefactoringPreferencesPanel.class);
    RefactoringPreferenceBean _prefs = null;
    JCheckBox qualifyTableNamesCheckBox = null;
    JCheckBox quoteIdentifersCheckBox = null;

    public RefactoringPreferencesPanel(RefactoringPreferenceBean prefs) {
        this._prefs = prefs;
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.6;
        this.add((Component)this.createBottomPanel(), c);
    }

    private JPanel createBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        String borderTitle = s_stringMgr.getString("RefactoringPreferencesPanel.borderTitle");
        result.setBorder(this.getTitledBorder(borderTitle));
        this.addQualifyTableNamesCheckBox(result, 0, 0);
        this.addQuoteIdentifiersCheckBox(result, 0, 1);
        return result;
    }

    private void addQualifyTableNamesCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("RefactoringPreferencesPanel.qualifyCheckboxLabel");
        String cbToolTipText = s_stringMgr.getString("RefactoringPreferencesPanel.qualifyCheckboxToolTip");
        this.qualifyTableNamesCheckBox = new JCheckBox(cbLabelStr);
        this.qualifyTableNamesCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.qualifyTableNamesCheckBox, c);
    }

    private void addQuoteIdentifiersCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("RefactoringPreferencesPanel.quoteCheckboxLabel");
        String cbToolTipText = s_stringMgr.getString("RefactoringPreferencesPanel.qualifyCheckboxToolTip");
        this.quoteIdentifersCheckBox = new JCheckBox(cbLabelStr);
        this.quoteIdentifersCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.quoteIdentifersCheckBox, c);
    }

    private Border getTitledBorder(String title) {
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new TitledBorder(title));
        return border;
    }

    private void loadData() {
        this.qualifyTableNamesCheckBox.setSelected(this._prefs.isQualifyTableNames());
        this.quoteIdentifersCheckBox.setSelected(this._prefs.isQuoteIdentifiers());
    }

    private void save() {
        this._prefs.setQualifyTableNames(this.qualifyTableNamesCheckBox.isSelected());
        this._prefs.setQuoteIdentifiers(this.quoteIdentifersCheckBox.isSelected());
        RefactoringPreferencesManager.savePrefs();
    }

    public void applyChanges() {
        this.save();
    }

    public Component getPanelComponent() {
        return this;
    }
}

