/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlscript.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.sqlscript.prefs.SQLScriptPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.sqlscript.prefs.SQLScriptPreferencesManager;

public class SQLScriptPreferencesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLScriptPreferencesPanel.class);
    private static final ILogger log = LoggerController.createLogger(SQLScriptPreferencesPanel.class);
    SQLScriptPreferenceBean _prefs = null;
    JCheckBox qualifyTableNamesCheckBox = null;
    JCheckBox useDoubleQuotesCheckBox = null;
    JCheckBox deleteReferentialActionCheckbox = null;
    JCheckBox updateReferentialActionCheckbox = null;
    JComboBox deleteActionComboBox = null;
    JComboBox updateActionComboBox = null;
    JLabel deleteActionLabel = null;
    JLabel updateActionLabel = null;
    JCheckBox escapeNewLineCheckBox;
    JLabel escapeNewLineLabel;
    JTextField escapeNewLineTextfield;

    public SQLScriptPreferencesPanel(SQLScriptPreferenceBean prefs) {
        this._prefs = prefs;
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.6;
        this.add((Component)this.createBottomPanel(), c);
    }

    private JPanel createBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        String borderTitle = s_stringMgr.getString("SQLScriptPreferencesPanel.borderTitle");
        result.setBorder(this.getTitledBorder(borderTitle));
        this.addQualifyTableNamesCheckBox(result, 0, 0);
        this.addUseDoubleQuotesCheckBox(result, 0, 1);
        this.addDeleteRefActionCheckBox(result, 0, 2);
        this.addDeleteActionComboBox(result, 0, 3);
        this.addUpdateRefActionCheckBox(result, 0, 4);
        this.addUpdateActionComboBox(result, 0, 5);
        this.addEscapeNewLineCheckBox(result, 0, 6);
        this.addEscapeNewLineTextField(result, 0, 7);
        return result;
    }

    private void addQualifyTableNamesCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.qualifyCheckboxLabel");
        String cbToolTipText = s_stringMgr.getString("SQLScriptPreferencesPanel.qualifyCheckboxToolTip");
        this.qualifyTableNamesCheckBox = new JCheckBox(cbLabelStr);
        this.qualifyTableNamesCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.qualifyTableNamesCheckBox, c);
        this.qualifyTableNamesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLScriptPreferencesPanel.this.onQualifyTableNamesCheckBox();
            }
        });
    }

    private void onQualifyTableNamesCheckBox() {
        if (this.qualifyTableNamesCheckBox.isSelected()) {
            this.useDoubleQuotesCheckBox.setEnabled(true);
        } else {
            this.useDoubleQuotesCheckBox.setSelected(false);
            this.useDoubleQuotesCheckBox.setEnabled(false);
        }
    }

    private void addDeleteRefActionCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.deleteRefActionCheckboxLabel");
        String cbToolTipText = s_stringMgr.getString("SQLScriptPreferencesPanel.deleteRefActionToolTip");
        this.deleteReferentialActionCheckbox = new JCheckBox(cbLabelStr);
        this.deleteReferentialActionCheckbox.setToolTipText(cbToolTipText);
        this.deleteReferentialActionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = SQLScriptPreferencesPanel.this.deleteReferentialActionCheckbox.isSelected();
                SQLScriptPreferencesPanel.this.deleteActionLabel.setEnabled(enabled);
                SQLScriptPreferencesPanel.this.deleteActionComboBox.setEnabled(enabled);
            }
        });
        panel.add((Component)this.deleteReferentialActionCheckbox, c);
    }

    private void addUpdateRefActionCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.updateRefActionCheckboxLabel");
        String cbToolTipText = s_stringMgr.getString("SQLScriptPreferencesPanel.updateRefActionToolTip");
        this.updateReferentialActionCheckbox = new JCheckBox(cbLabelStr);
        this.updateReferentialActionCheckbox.setToolTipText(cbToolTipText);
        this.updateReferentialActionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = SQLScriptPreferencesPanel.this.updateReferentialActionCheckbox.isSelected();
                SQLScriptPreferencesPanel.this.updateActionLabel.setEnabled(enabled);
                SQLScriptPreferencesPanel.this.updateActionComboBox.setEnabled(enabled);
            }
        });
        panel.add((Component)this.updateReferentialActionCheckbox, c);
    }

    private void addEscapeNewLineCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.escapeNewLine");
        this.escapeNewLineCheckBox = new JCheckBox(cbLabelStr);
        this.escapeNewLineCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = SQLScriptPreferencesPanel.this.escapeNewLineCheckBox.isSelected();
                SQLScriptPreferencesPanel.this.escapeNewLineLabel.setEnabled(enabled);
                SQLScriptPreferencesPanel.this.escapeNewLineTextfield.setEnabled(enabled);
            }
        });
        panel.add((Component)this.escapeNewLineCheckBox, c);
    }

    private void addDeleteActionComboBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        c.anchor = 17;
        JPanel subpanel = new JPanel();
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.deleteActionLabel");
        this.deleteActionLabel = new JLabel(cbLabelStr);
        this.deleteActionLabel.setHorizontalAlignment(2);
        this.deleteActionComboBox = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"NO ACTION", "CASCADE", "SET DEFAULT", "SET NULL"});
        this.deleteActionComboBox.setModel(model);
        subpanel.add(this.deleteActionLabel);
        subpanel.add(this.deleteActionComboBox);
        panel.add((Component)subpanel, c);
    }

    private void addUseDoubleQuotesCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        c.anchor = 17;
        this.useDoubleQuotesCheckBox = new JCheckBox(s_stringMgr.getString("SQLScriptPreferencesPanel.useDoubleQuotesForQualifying"));
        panel.add((Component)this.useDoubleQuotesCheckBox, c);
    }

    private void addUpdateActionComboBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        c.anchor = 17;
        JPanel subpanel = new JPanel();
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.updateActionLabel");
        this.updateActionLabel = new JLabel(cbLabelStr);
        this.updateActionLabel.setHorizontalAlignment(2);
        this.updateActionComboBox = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(new String[]{"NO ACTION", "CASCADE", "SET DEFAULT", "SET NULL"});
        this.updateActionComboBox.setModel(model);
        subpanel.add(this.updateActionLabel);
        subpanel.add(this.updateActionComboBox);
        panel.add((Component)subpanel, c);
    }

    private void addEscapeNewLineTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        c.anchor = 17;
        JPanel subpanel = new JPanel();
        String cbLabelStr = s_stringMgr.getString("SQLScriptPreferencesPanel.escapeNewLineTextfieldLabel");
        this.escapeNewLineLabel = new JLabel(cbLabelStr);
        this.escapeNewLineLabel.setHorizontalAlignment(2);
        this.escapeNewLineTextfield = new JTextField();
        this.escapeNewLineTextfield.setPreferredSize(new Dimension(50, this.escapeNewLineCheckBox.getPreferredSize().height));
        subpanel.add(this.escapeNewLineLabel);
        subpanel.add(this.escapeNewLineTextfield);
        panel.add((Component)subpanel, c);
    }

    private Border getTitledBorder(String title) {
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new TitledBorder(title));
        return border;
    }

    private void loadData() {
        this.qualifyTableNamesCheckBox.setSelected(this._prefs.isQualifyTableNames());
        this.useDoubleQuotesCheckBox.setEnabled(this._prefs.isQualifyTableNames());
        this.useDoubleQuotesCheckBox.setSelected(this._prefs.isQualifyTableNames() && this._prefs.isUseDoubleQuotes());
        this.deleteReferentialActionCheckbox.setSelected(this._prefs.isDeleteRefAction());
        this.deleteActionComboBox.setEnabled(this.deleteReferentialActionCheckbox.isSelected());
        this.deleteActionComboBox.setSelectedIndex(this._prefs.getDeleteAction());
        this.updateReferentialActionCheckbox.setSelected(this._prefs.isUpdateRefAction());
        this.updateActionComboBox.setEnabled(this.updateReferentialActionCheckbox.isSelected());
        this.updateActionComboBox.setSelectedIndex(this._prefs.getUpdateAction());
        this.escapeNewLineCheckBox.setSelected(this._prefs.isEscapeNewLine());
        this.escapeNewLineTextfield.setText(this._prefs.getEscapeNewLineString());
        this.escapeNewLineTextfield.setEnabled(this._prefs.isEscapeNewLine());
        this.escapeNewLineLabel.setEnabled(this._prefs.isEscapeNewLine());
    }

    private void save() {
        this._prefs.setQualifyTableNames(this.qualifyTableNamesCheckBox.isSelected());
        this._prefs.setUseDoubleQuotes(this.useDoubleQuotesCheckBox.isSelected());
        this._prefs.setDeleteRefAction(this.deleteReferentialActionCheckbox.isSelected());
        this._prefs.setUpdateRefAction(this.updateReferentialActionCheckbox.isSelected());
        int action = this.deleteActionComboBox.getSelectedIndex();
        this._prefs.setDeleteAction(action);
        action = this.updateActionComboBox.getSelectedIndex();
        this._prefs.setUpdateAction(action);
        this._prefs.setEscapeNewLine(this.escapeNewLineCheckBox.isSelected());
        String escapeString = "\\n";
        if (null != this.escapeNewLineTextfield.getText()) {
            escapeString = this.escapeNewLineTextfield.getText();
        }
        this._prefs.setEscapeNewLineString(escapeString);
        SQLScriptPreferencesManager.savePrefs();
    }

    public void applyChanges() {
        this.save();
    }

    public Component getPanelComponent() {
        return this;
    }
}

