/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryComboBoxModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLHistoryItem;
import net.sourceforge.squirrel_sql.fw.gui.MemoryComboBox;

public class SQLHistoryComboBox
extends MemoryComboBox {
    public SQLHistoryComboBox(boolean useSharedModel) {
        this.setModel(new SQLHistoryComboBoxModel(useSharedModel));
        this.setRenderer(new Renderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLHistoryComboBox.this.updateToolTip();
            }
        });
    }

    public SQLHistoryComboBoxModel getTypedModel() {
        return (SQLHistoryComboBoxModel)this.getModel();
    }

    public void setUseSharedModel(boolean use) {
        this.getTypedModel().setUseSharedModel(use);
    }

    public boolean isUsingSharedDataModel() {
        return this.getTypedModel().isUsingSharedDataModel();
    }

    private void updateToolTip() {
        String tt = " ";
        SQLHistoryItem shi = (SQLHistoryItem)this.getSelectedItem();
        if (shi != null) {
            tt = this.formatToolTip(shi.getSQL());
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JComponent)) continue;
            ((JComponent)comps[i]).setToolTipText(tt);
        }
    }

    private String formatToolTip(String tt) {
        StringBuffer buf = new StringBuffer();
        buf.append("<HTML><PRE>");
        if (200 < tt.length()) {
            buf.append(tt.substring(0, 200)).append(" ...");
        } else {
            buf.append(tt);
        }
        buf.append("</PRE></HTML>");
        return buf.toString();
    }

    public void dispose() {
        this.setModel(new DefaultComboBoxModel());
    }

    private final class Renderer
    extends BasicComboBoxRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index != -1) {
                    String tt = ((SQLHistoryItem)value).getSQL();
                    String text = SQLHistoryComboBox.this.formatToolTip(tt);
                    list.setToolTipText(text);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

