/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.lexer.managers;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.AbstractRubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.ContentManager;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.StatesManager;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.managers.state.Expr;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;

public class TokensManager
implements RubyTokenTypes {
    private final StatesManager a;
    private boolean b;
    private final ContentManager c;
    private final AbstractRubyLexer d;

    public TokensManager(AbstractRubyLexer lexer) {
        this.d = lexer;
        this.a = lexer.getStatesManager();
        this.c = lexer.getContentManager();
    }

    public void reset() {
        this.b = false;
    }

    public boolean reswordAllowed() {
        return !this.isFnameAllowed() && (!this.d.isRuby19Enabled() || this.c.safeReadAt(this.d.yylength()) != ':');
    }

    public boolean afterDotOrColon() {
        return this.a.getExpr() == Expr.DOT_OR_COLON;
    }

    public boolean isAssignOpAllowed() {
        return this.a.getExpr() == Expr.FNAME;
    }

    public boolean isFnameAllowed() {
        Expr expr = this.a.getExpr();
        return expr == Expr.FNAME || expr == Expr.DOT_OR_COLON || expr == Expr.CMD_BRACE && TokenBNF.tCALL.contains(this.a.getLastTokenType());
    }

    public boolean isColon2Allowed() {
        Expr expr = this.a.getExpr();
        return expr == Expr.END || expr == Expr.CMD_ARG || expr == Expr.ARG && !this.b || expr == Expr.CMD_BRACE && this.a.isPipeSeen() && !this.b;
    }

    public boolean isSymBegAllowed(boolean followCharIsWhiteSpaceOrEol) {
        if (this.a.isInAlias() || this.a.isInUndef()) {
            return true;
        }
        return this.unaryAllowed(followCharIsWhiteSpaceOrEol);
    }

    public boolean stringAllowed() {
        return this.stringAllowed(false);
    }

    public boolean stringAllowed(boolean followCharIsWhiteSpaceOrEol) {
        Expr expr = this.a.getExpr();
        return !this.isFnameAllowed() && (expr == Expr.BEG || expr == Expr.CMD_BRACE || expr == Expr.MID || expr == Expr.ARG && this.b && !followCharIsWhiteSpaceOrEol);
    }

    public boolean unaryAllowed(boolean followCharIsWhiteSpaceOrEol) {
        if (this.isFnameAllowed()) {
            return false;
        }
        Expr expr = this.a.getExpr();
        if (expr == Expr.BEG || expr == Expr.MID || expr == Expr.CMD_ARG) {
            return true;
        }
        if (expr == Expr.ARG && !followCharIsWhiteSpaceOrEol) {
            return this.b || this.a.getLastTokenType() == Ruby19TokenTypes.tARROW;
        }
        if (this.a.isPipeSeen()) {
            IElementType iElementType = this.a.getLastTokenType();
            return (iElementType == tPIPE || iElementType == tCOMMA || this.b) && !followCharIsWhiteSpaceOrEol;
        }
        return expr == Expr.CMD_BRACE;
    }

    public boolean isHeredocAllowed() {
        return this.a.getExpr() != Expr.CLASS && this.unaryAllowed(false);
    }

    public IElementType process(IElementType type) {
        if (type != tLINE_CONTINUATION) {
            this.b = type == tWHITE_SPACE;
        }
        this.a.process(type);
        return type;
    }

    public boolean ignoreEOL() {
        Expr expr = this.a.getExpr();
        if (this.a.isInDefState() && !this.a.isIgnoreEol()) {
            return false;
        }
        return !this.a.isAfterHeredoc() && (expr == Expr.BEG || expr == Expr.MID || expr == Expr.CMD_BRACE && this.a.isIgnoreEol() || expr == Expr.DOT_OR_COLON || expr == Expr.CLASS || expr == Expr.FNAME);
    }

    public boolean isFTokenAllowed() {
        return !this.b && this.isExprEnd();
    }

    public boolean isArgTokenAllowed() {
        return this.b && this.a.getExpr() == Expr.ARG;
    }

    public boolean isExprEnd() {
        Expr expr = this.a.getExpr();
        return expr == Expr.END || expr == Expr.ARG;
    }
}

