/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import b.h.la;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyValueModifier;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyExpressionCodeFragmentImpl;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebugValue
extends XValue {
    private static final Logger a;
    protected final Project myProject;
    @Nullable
    protected final XSourcePosition myPosition;
    protected String myName;
    @NotNull
    protected RubyValue myValue;
    private final boolean c;
    protected final RubyStackFrame myFrame;
    @NotNull
    private final Icon b;
    private static final long h;

    public RubyDebugValue(Project project, XSourcePosition position, @NotNull String name, @NotNull RubyValue value, boolean canEvaluate, RubyStackFrame frame) {
        if (name == null) {
            RubyDebugValue.a(0);
        }
        if (value == null) {
            RubyDebugValue.a(1);
        }
        this(project, position, name, value, canEvaluate, frame, AllIcons.Debugger.Value);
    }

    protected RubyDebugValue(Project project, @Nullable XSourcePosition position, @NotNull String name, @NotNull RubyValue value, boolean canEvaluate, RubyStackFrame frame, @NotNull Icon icon) {
        if (name == null) {
            RubyDebugValue.a(2);
        }
        if (value == null) {
            RubyDebugValue.a(3);
        }
        if (icon == null) {
            RubyDebugValue.a(4);
        }
        this.myProject = project;
        this.myPosition = position;
        this.myName = name;
        this.myValue = value;
        this.c = canEvaluate;
        this.myFrame = frame;
        this.b = icon;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            RubyDebugValue.a(5);
        }
        if (place == null) {
            RubyDebugValue.a(6);
        }
        if (node.isObsolete()) {
            return;
        }
        node.setPresentation(this.a(node), (XValuePresentation)new RubyInlinePresentation(this.myValue.getValueString(), this.getPresentableTypeName(place)), this.myValue.hasVariables());
    }

    @Nullable
    protected String getPresentableTypeName(@NotNull XValuePlace place) {
        long l2 = h ^ 0xBCB9BA1A70BL;
        if (place == null) {
            RubyDebugValue.a(7);
        }
        if (place == XValuePlace.TOOLTIP) {
            return null;
        }
        String string = this.myValue.getReferenceTypeName();
        if ("Array".equals(string) || "Hash".equals(string) || "NilClass".equals(string) || "TrueClass".equals(string) || "FalseClass".equals(string) || "Bignum".equals(string) || "Fixnum".equals(string) || "Float".equals(string) || "String".equals(string) || "Integer".equals(string)) {
            return null;
        }
        return string;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            RubyDebugValue.a(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (node == null) {
                RubyDebugValue.a(18);
            }
            try {
                this.computeChildren(node, this.myValue.getVariables());
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                a.info((Throwable)rubyDebuggerException);
            }
        });
    }

    protected void computeChildren(@NotNull XCompositeNode node, RubyVariable[] variables) {
        if (node == null) {
            RubyDebugValue.a(9);
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.myPosition, node, variables, this.myFrame, true);
    }

    public final String getEvaluationExpression() {
        return this.c ? this.myName : null;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        long l2 = h ^ 0x69A42371FDD7L;
        if (navigatable == null) {
            RubyDebugValue.a(10);
        }
        if ("self".equals(this.myName) || "block".equals(this.myName) || this.myPosition == null) {
            return;
        }
        if (TextUtil.isCID(this.myName) || TextUtil.isField(this.myName)) {
            Document document = RubyDebuggerSupportUtils.createDocument(this.myName, this.myProject, this.myPosition.getFile(), this.myPosition.getOffset());
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            a.assertTrue(psiFile != null);
            PsiReference psiReference = ((RPsiElement)((RubyExpressionCodeFragmentImpl)psiFile).getCompoundStatement().getStatements().get(0)).getReference();
            if (psiReference instanceof RPsiPolyVariantReference) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (navigatable == null) {
                        RubyDebugValue.a(16);
                    }
                    ReadAction.run(() -> {
                        PsiElement psiElement;
                        if (navigatable == null) {
                            RubyDebugValue.a(17);
                        }
                        if ((psiElement = ResolveUtil.resolvePsiMultiReference((RPsiPolyVariantReference)psiReference)) != null) {
                            XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPositionByOffset(psiElement.getContainingFile().getVirtualFile(), psiElement.getTextOffset());
                            navigatable.setSourcePosition(xSourcePosition);
                        }
                    });
                });
            }
        }
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        PsiFile psiFile;
        PsiElement psiElement;
        Symbol symbol;
        if (navigatable == null) {
            RubyDebugValue.a(11);
        }
        if ((symbol = SymbolUtil.findConstantByFQN(this.myProject, this.myValue.getReferenceTypeName())) != null && (psiElement = (PsiElement)ContainerUtil.getFirstItem((Collection)symbol.getAllDeclarations(psiFile = this.myPosition != null ? PsiManager.getInstance((Project)this.myProject).findFile(this.myPosition.getFile()) : null))) != null) {
            XSourcePosition xSourcePosition = XDebuggerUtil.getInstance().createPositionByOffset(psiElement.getContainingFile().getVirtualFile(), psiElement.getTextOffset());
            navigatable.setSourcePosition(xSourcePosition);
        }
    }

    public boolean canNavigateToSource() {
        return this.myPosition != null;
    }

    public boolean canNavigateToTypeSource() {
        return this.myValue.getReferenceTypeName() != null;
    }

    public XValueModifier getModifier() {
        return new RubyValueModifier(this.myFrame, this.myName, this.myValue);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof RubyDebugValue)) {
            return false;
        }
        RubyDebugValue rubyDebugValue = (RubyDebugValue)((Object)o2);
        if (!this.myName.equals(rubyDebugValue.myName)) {
            return false;
        }
        return this.myValue.equals(rubyDebugValue.myValue);
    }

    public int hashCode() {
        int n2 = this.myName.hashCode();
        n2 = 31 * n2 + this.myValue.hashCode();
        return n2;
    }

    @NotNull
    private Icon a(@NotNull XValueNode xValueNode) {
        XDebugSessionTab xDebugSessionTab;
        if (xValueNode == null) {
            RubyDebugValue.a(12);
        }
        if (!(xValueNode instanceof WatchNodeImpl)) {
            Icon icon = this.b;
            if (icon == null) {
                RubyDebugValue.a(13);
            }
            return icon;
        }
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (xDebugSession != null && (xDebugSessionTab = ((XDebugSessionImpl)xDebugSession).getSessionTab()) != null && !xDebugSessionTab.isWatchesInVariables()) {
            Icon icon = this.b;
            if (icon == null) {
                RubyDebugValue.a(14);
            }
            return icon;
        }
        Icon icon = AllIcons.Debugger.Db_watch;
        if (icon == null) {
            RubyDebugValue.a(15);
        }
        return icon;
    }

    static {
        h = la.a(-1570860146585813654L, -2553550239737273828L, MethodHandles.lookup().lookupClass()).a(221919426725652L);
        a = Logger.getInstance(RubyDebugValue.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x6F15319CD2AL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchesAwareIcon";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableTypeName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWatchesAwareIcon";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeSourcePosition$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeChildren$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RubyInlinePresentation
    extends XRegularValuePresentation
    implements XValueCompactPresentation {
        private static final long a = la.a(3317930300629110348L, -7163513610331117303L, MethodHandles.lookup().lookupClass()).a(121540343180418L);

        RubyInlinePresentation(String value, String typeName) {
            super(RubyDebuggerSupportUtils.convertToIdeEncoding(value), typeName);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
            if (renderer == null) {
                RubyInlinePresentation.a(0);
            }
            if (node == null) {
                return;
            }
            RubyDebugValue rubyDebugValue = (RubyDebugValue)node.getValueContainer();
            renderer.renderValue(RubyDebuggerSupportUtils.convertToIdeEncoding(rubyDebugValue.myValue.getOwner().getCompactValue()));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x7726097E7833L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValue$RubyInlinePresentation", "renderValue"));
        }
    }
}

