/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.List;

public class TreeHashingUtils {
    protected static TreeHashResult hashCodeBlockForIndexing(AbstractTreeHasher treeHasher, FragmentsCollector callBack, List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher) {
        int n2 = statements.size();
        if (n2 > 0) {
            TreePsiFragment treePsiFragment = treeHasher.buildFragment(hasher, statements, 0, n2 - 1);
            treePsiFragment.setParent(upper);
            int n3 = 0;
            int n4 = 0;
            for (PsiElement psiElement : statements) {
                TreeHashResult treeHashResult = treeHasher.hash(psiElement, null, hasher);
                n4 = n4 * 31 + treeHashResult.getHash();
                n3 += treeHashResult.getCost();
            }
            TreeHashResult treeHashResult = new TreeHashResult(n4, n3, treeHasher.buildFragment(hasher, statements, 0, n2 - 1));
            if (callBack != null && n2 > 1) {
                callBack.add(n4, n3, treePsiFragment);
            }
            return treeHashResult;
        }
        return new TreeHashResult(1, 0, treeHasher.buildFragment(hasher, statements, 0, n2 - 1));
    }

    static TreeHashResult computeElementHashForIndexing(AbstractTreeHasher base, FragmentsCollector callBack, PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        int n2;
        List<PsiElement> list2 = hasher.getNodeChildren(root);
        TreePsiFragment treePsiFragment = base.buildFragment(hasher, root, base.getCost(root));
        if (upper != null) {
            treePsiFragment.setParent(upper);
        }
        if ((n2 = list2.size()) == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root), treePsiFragment);
        }
        int n3 = base.getDiscardCost(root);
        int n4 = hasher.getNodeCost(root);
        int n5 = hasher.getNodeHash(root);
        for (int i10 = 0; i10 < n2; ++i10) {
            PsiElement psiElement = list2.get(i10);
            TreeHashResult treeHashResult = base.hash(psiElement, treePsiFragment, hasher);
            int n6 = treeHashResult.getCost();
            n4 += n6;
            if (n6 <= n3 && base.ignoreChildHash(psiElement)) continue;
            n5 += treeHashResult.getHash();
        }
        if (base.shouldAnonymize(root, hasher)) {
            n5 = 0;
        }
        if (callBack != null) {
            callBack.add(n5, n4, treePsiFragment);
        }
        return new TreeHashResult(n5, n4, treePsiFragment);
    }
}

