/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.EndIncElementPattern;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCreateTypeBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTableParenthesizedColumnsSection;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0014J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "flowPatterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "userRequiresExpand", "", "whetherToFlatten", "node", "Lcom/intellij/lang/ASTNode;", "Companion", "intellij.database.sql.impl"})
public final class SqlCreateTypeBlock
extends SqlNodeBlock {
    @NotNull
    private static final Map<IElementType, FlowPattern> patterns;
    public static final Companion Companion;

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)SqlCompositeElementTypes.SQL_TYPE_ELEMENT)) {
            return SqlUtilFun.firstLeaf(node).getElementType() == SqlCommonKeywords.SQL_TABLE;
        }
        return super.whetherToFlatten(node);
    }

    @Override
    @NotNull
    protected Map<IElementType, FlowPattern> flowPatterns() {
        return patterns;
    }

    @Override
    public boolean userRequiresExpand() {
        return true;
    }

    @Override
    protected void configureFormattingAttributes() {
        for (SqlBlock b2 : this.getNestedBlocks()) {
            SqlBlock sqlBlock = b2;
            if (sqlBlock instanceof SqlKeyword) {
                IElementType iElementType = ((SqlKeyword)b2).getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_AS) && !Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_IS)) continue;
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (!(sqlBlock instanceof SqlTableParenthesizedColumnsSection)) continue;
            b2.setMyWrap(this.getContext().getSql().TABLE_OPENING > 1 ? SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.ALWAYS, false, 2, null) : null);
            b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
        }
    }

    static {
        Companion = new Companion(null);
        patterns = MapsKt.mapOf((Pair)TuplesKt.to((Object)SqlCommonTokens.SQL_LEFT_PAREN, (Object)new EndIncElementPattern(SetsKt.setOf((Object)SqlCommonTokens.SQL_RIGHT_PAREN), SetsKt.emptySet(), (Function0<? extends SqlRangeBlock>)((Function0)Companion.patterns.1.INSTANCE))));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/formatter/model/SqlCreateTypeBlock$Companion;", "", "()V", "patterns", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "getPatterns", "()Ljava/util/Map;", "intellij.database.sql.impl"})
    public static final class Companion {
        @NotNull
        public final Map<IElementType, FlowPattern> getPatterns() {
            return patterns;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

