/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramScopeManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;

public class DiagramPsiScopeManager<T>
extends DiagramScopeManager<T> {
    @Override
    public boolean contains(T element) {
        PackageSet packageSet;
        PsiFile psiFile;
        NamedScope scope = this.getCurrentScope();
        if (scope == null) {
            return true;
        }
        Project project = this.getProject();
        NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)project, (String)scope.getName(), (NamedScopesHolder)DependencyValidationManager.getInstance((Project)project));
        if (element instanceof PsiDirectoryContainer) {
            PackageSet value = scope.getValue();
            if (value instanceof PackageSetBase) {
                PackageSetBase packageSet2 = (PackageSetBase)value;
                for (PsiDirectory directory : ((PsiDirectoryContainer)element).getDirectories()) {
                    if (!packageSet2.contains(directory.getVirtualFile(), project, holder)) continue;
                    return true;
                }
            }
        } else if (element instanceof PsiElement && (psiFile = ((PsiElement)element).getContainingFile()) != null && (packageSet = scope.getValue()) != null) {
            return packageSet.contains(psiFile, holder);
        }
        return false;
    }

    public DiagramPsiScopeManager(Project project) {
        super(project);
    }
}

