/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deployment.ui;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.cli.CliParserBase;
import com.intellij.docker.cli.NormalizedCommandLine;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.execution.ParametersListUtil;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerCliOptionsField
extends ExpandableTextField {
    private final NormalizedCommandLine.CliSplitter mySplitter;

    protected DockerCliOptionsField(@NotNull NormalizedCommandLine.CliSplitter splitter) {
        if (splitter == null) {
            DockerCliOptionsField.$$$reportNull$$$0(0);
        }
        super(splitter::splitCliOptions, ParametersListUtil.DEFAULT_LINE_JOINER);
        this.mySplitter = splitter;
    }

    @NotNull
    protected NormalizedCommandLine.CliSplitter getSplitter() {
        NormalizedCommandLine.CliSplitter cliSplitter = this.mySplitter;
        if (cliSplitter == null) {
            DockerCliOptionsField.$$$reportNull$$$0(1);
        }
        return cliSplitter;
    }

    public abstract void resetEditorFrom(@NotNull DockerDeploymentConfiguration var1);

    public void applyValueTo(@NotNull DockerDeploymentConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            DockerCliOptionsField.$$$reportNull$$$0(2);
        }
        this.storeRawText(configuration);
        try {
            this.getParsedOptions();
        }
        catch (ParseException e) {
            this.handleParseException(e);
        }
        catch (CliParserBase.IllegalOptionException e) {
            throw new RuntimeConfigurationWarning(e.getMessage());
        }
    }

    protected abstract void storeRawText(@NotNull DockerDeploymentConfiguration var1);

    protected void handleParseException(ParseException e) throws ConfigurationException {
        throw new RuntimeConfigurationWarning(DockerBundle.getText("DockerCliOptionsField.onParseError", e.getMessage()));
    }

    @Nullable
    public NormalizedCommandLine getParsedOptions() throws ParseException, CliParserBase.IllegalOptionException {
        String optionsLine = this.getText();
        if (StringUtil.isEmptyOrSpaces((String)optionsLine)) {
            return null;
        }
        return this.mySplitter.trySplitCliOptions(optionsLine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deployment/ui/DockerCliOptionsField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deployment/ui/DockerCliOptionsField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyValueTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

