/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Argument;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolFilterFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class GetSymbolMembers
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyGetSymbolMembers";

    public GetSymbolMembers(@NotNull Project project, @NotNull String text, int line) {
        if (project == null) {
            GetSymbolMembers.$$$reportNull$$$0(0);
        }
        if (text == null) {
            GetSymbolMembers.$$$reportNull$$$0(1);
        }
        super(project, text, line, PREFIX, new Options(), false);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper(this.getProject());
        ReadAction.run(() -> this.lambda$_execute$0(context, (ActionCallback)actionCallback));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    @NotNull
    private Context getContext() {
        switch (((Options)this.getOptions()).context) {
            case "INSTANCE": {
                Context context = Context.INSTANCE;
                if (context == null) {
                    GetSymbolMembers.$$$reportNull$$$0(2);
                }
                return context;
            }
            case "CLASS": {
                Context context = Context.CLASS;
                if (context == null) {
                    GetSymbolMembers.$$$reportNull$$$0(3);
                }
                return context;
            }
            case "INSTANCE_PRIVATE": {
                Context context = Context.INSTANCE_PRIVATE;
                if (context == null) {
                    GetSymbolMembers.$$$reportNull$$$0(4);
                }
                return context;
            }
            case "CLASS_PRIVATE": {
                Context context = Context.CLASS_PRIVATE;
                if (context == null) {
                    GetSymbolMembers.$$$reportNull$$$0(5);
                }
                return context;
            }
        }
        throw new IllegalArgumentException(((Options)this.getOptions()).context);
    }

    private /* synthetic */ void lambda$_execute$0(PlaybackContext context, ActionCallback actionCallback) throws RuntimeException {
        Options options = (Options)this.getOptions();
        if (options.clearCache) {
            this.clearCaches();
        }
        long time = System.currentTimeMillis();
        Symbol symbol = SymbolUtil.findConstantByFQN((Project)this.getProject(), (String)options.fqn);
        RType type = RTypeFactory.createTypeBySymbol((Symbol)symbol, (Context)this.getContext());
        Collection members = type.getMembers(SymbolFilterFactory.EMPTY_FILTER, null);
        context.message(String.format("Got %d for %s with %s %dms", members.size(), options.fqn, options.context, System.currentTimeMillis() - time), this.getLine());
        actionCallback.setDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ruby/performanceTesting/GetSymbolMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ruby/performanceTesting/GetSymbolMembers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Options {
        @Argument
        public String fqn;
        @Argument
        public String context = "INSTANCE";
        @Argument
        public boolean clearCache;
    }
}

