/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6FileType;
import com.intellij.lang.ecmascript6.JSXHarmonyFileType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.index.IndexedFileTypeProvider;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptResolveScopeProvider
extends JSResolveScopeProvider
implements JSElementResolveScopeProvider {
    private static final Set<FileType> myExpandedScopeFileTypes;

    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file2, Project project) {
        if (file2 == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (!JavaScriptResolveScopeProvider.isApplicable(file2)) {
            return null;
        }
        return this.getProjectAndLibrariesScope(file2, project);
    }

    @NotNull
    public GlobalSearchScope getProjectAndLibrariesScope(@NotNull VirtualFile file2, Project project) {
        if (file2 == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        Set<VirtualFile> includedFiles = JSLibraryManager.getInstance(project).getRequiredLibraryFilesForResolve();
        GlobalSearchScope globalSearchScope = this.getProjectAndLibrariesScope(file2, project, includedFiles, Collections.emptySet());
        if (globalSearchScope == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    @Nullable
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if (!((language = DialectDetector.languageOfElement(element)) == JavascriptLanguage.INSTANCE || language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isJavaScript())) {
            return null;
        }
        VirtualFile file2 = JSResolveScopeProvider.getFileForScopeEvaluation(element);
        if (file2 != null && JavaScriptResolveScopeProvider.isApplicable(file2)) {
            return null;
        }
        Project project = element.getProject();
        GlobalSearchScope result2 = this.getProjectScopeIncludingPredefines(project);
        if (file2 != null) {
            for (ResolveScopeEnlarger enlarger : (ResolveScopeEnlarger[])ResolveScopeEnlarger.EP_NAME.getExtensions()) {
                SearchScope extra = enlarger.getAdditionalResolveScope(file2, project);
                if (extra == null) continue;
                result2 = result2.union(extra);
            }
        }
        return result2;
    }

    protected static boolean isApplicable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return myExpandedScopeFileTypes.contains(file2.getFileType());
    }

    @Override
    protected List<VirtualFile> getPredefinedLibraryFiles(@NotNull Project project) {
        if (project == null) {
            JavaScriptResolveScopeProvider.$$$reportNull$$$0(5);
        }
        return ContainerUtil.newArrayList(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
    }

    static {
        THashSet expandedScopeFileTypes = new THashSet(4);
        expandedScopeFileTypes.add(JavaScriptSupportLoader.JAVASCRIPT);
        expandedScopeFileTypes.add(ES6FileType.INSTANCE);
        expandedScopeFileTypes.add(FlowJSFileType.INSTANCE);
        expandedScopeFileTypes.add(HtmlFileType.INSTANCE);
        expandedScopeFileTypes.add(JSXHarmonyFileType.INSTANCE);
        for (IndexedFileTypeProvider iftp : IndexedFileTypeProvider.EP_NAME.getExtensionList()) {
            Collections.addAll(expandedScopeFileTypes, iftp.getFileTypesToIndex());
        }
        myExpandedScopeFileTypes = expandedScopeFileTypes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JavaScriptResolveScopeProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectAndLibrariesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectAndLibrariesScope";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementResolveScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraryFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

