/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.rhino;

import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptableObject;

public class RhinoUtil {
    private RhinoUtil() {
    }

    @NotNull
    public static Object toRhinoAnyNotNull(@NotNull Object object) {
        if (object == null) {
            RhinoUtil.$$$reportNull$$$0(0);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            NativeObject nativeObject = RhinoUtil.toRhinoMap(map);
            if (nativeObject == null) {
                RhinoUtil.$$$reportNull$$$0(1);
            }
            return nativeObject;
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof String) {
            Object object2 = object;
            if (object2 == null) {
                RhinoUtil.$$$reportNull$$$0(2);
            }
            return object2;
        }
        if (object instanceof List) {
            NativeArray nativeArray = RhinoUtil.toRhinoArray((List)object);
            if (nativeArray == null) {
                RhinoUtil.$$$reportNull$$$0(3);
            }
            return nativeArray;
        }
        if (object instanceof Object[]) {
            throw new RuntimeException("Java arrays aren't supported, please use " + List.class);
        }
        throw new RuntimeException("Unexpected rhino object " + object);
    }

    @Nullable
    public static Object toRhinoAny(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return RhinoUtil.toRhinoAnyNotNull(object);
    }

    public static NativeArray toRhinoArray(@NotNull List<Object> list) {
        if (list == null) {
            RhinoUtil.$$$reportNull$$$0(4);
        }
        Object[] resArray = new Object[list.size()];
        int i = 0;
        for (Object o : list) {
            Object res;
            resArray[i] = res = RhinoUtil.toRhinoAny(o);
            ++i;
        }
        return new NativeArray(resArray);
    }

    @NotNull
    public static NativeObject toRhinoMap(@NotNull Map<String, ?> map) {
        if (map == null) {
            RhinoUtil.$$$reportNull$$$0(5);
        }
        NativeObject object = new NativeObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object nativeObj = RhinoUtil.toRhinoAny(entry.getValue());
            object.defineProperty(entry.getKey(), nativeObj, 1);
        }
        NativeObject nativeObject = object;
        if (nativeObject == null) {
            RhinoUtil.$$$reportNull$$$0(6);
        }
        return nativeObject;
    }

    @Nullable
    public static Object toJavaAny(@Nullable Object rhinoObject) {
        if (rhinoObject instanceof NativeObject) {
            return RhinoUtil.toJavaMap((NativeObject)rhinoObject);
        }
        if (rhinoObject instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)rhinoObject;
            return Arrays.asList(nativeArray.toArray());
        }
        return rhinoObject;
    }

    @NotNull
    public static Map<Object, Object> toJavaMap(@NotNull NativeObject nativeObject) {
        if (nativeObject == null) {
            RhinoUtil.$$$reportNull$$$0(7);
        }
        HashMap copy = ContainerUtil.newHashMap();
        for (Map.Entry entry : nativeObject.entrySet()) {
            Object regularKey = RhinoUtil.toJavaAny(entry.getKey());
            Object regularValue = RhinoUtil.toJavaAny(entry.getValue());
            copy.put(regularKey, regularValue);
        }
        HashMap hashMap = copy;
        if (hashMap == null) {
            RhinoUtil.$$$reportNull$$$0(8);
        }
        return hashMap;
    }

    @Nullable
    public static String getStringKey(@NotNull ScriptableObject object, @NotNull String key) {
        if (object == null) {
            RhinoUtil.$$$reportNull$$$0(9);
        }
        if (key == null) {
            RhinoUtil.$$$reportNull$$$0(10);
        }
        Object value = object.get((Object)key);
        String str = null;
        if (value instanceof String) {
            str = (String)value;
        } else if (value instanceof ConsString) {
            ConsString consString = (ConsString)value;
            str = consString.toString();
        }
        return str;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/rhino/RhinoUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeObject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/rhino/RhinoUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toRhinoAnyNotNull";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toRhinoMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toJavaMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toRhinoAnyNotNull";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toRhinoArray";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toRhinoMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toJavaMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStringKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

