/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.settings.NodeCoreSourcesView;
import com.intellij.javascript.nodejs.settings.NodePackagesView;
import com.intellij.javascript.nodejs.settings.NodeVersionListener;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.FormBuilder;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsView {
    private final boolean myOneClickConfiguration;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myPmPackageField;
    private final JComponent myComponent;
    private final List<NodeVersionListener> myVersionListeners;

    public NodeSettingsView(@NotNull Project project, @Nullable VirtualFile requestor, boolean oneClickConfiguration) {
        JComponent bottomComponent;
        if (project == null) {
            NodeSettingsView.$$$reportNull$$$0(0);
        }
        this.myVersionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myOneClickConfiguration = oneClickConfiguration;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false){

            @Override
            public boolean isDefaultProjectInterpreterField() {
                return true;
            }
        };
        this.myPmPackageField = NpmUtil.createPackageManagerPackageField(this.myNodeInterpreterField, true);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().setAlignLabelOnRight(false);
        formBuilder.addLabeledComponent("Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField));
        NodeCoreSourcesView nodeCoreSourcesView = new NodeCoreSourcesView(project, requestor);
        formBuilder.addComponent(nodeCoreSourcesView.getComponent(), 4);
        formBuilder.addLabeledComponent("Package &manager:", (JComponent)((Object)this.myPmPackageField), 8);
        this.myVersionListeners.add(nodeCoreSourcesView);
        if (!project.isDefault()) {
            NodePackagesView nodePackagesView = new NodePackagesView(project, oneClickConfiguration);
            this.myVersionListeners.add(nodePackagesView);
            bottomComponent = nodePackagesView.getComponent();
        } else {
            bottomComponent = new JPanel();
        }
        formBuilder.addComponentFillVertically(bottomComponent, 4);
        this.myComponent = formBuilder.getPanel();
        this.listenForNodeInterpreterPathUpdate();
    }

    private void listenForNodeInterpreterPathUpdate() {
        this.myNodeInterpreterField.addChangeListener(this::handleNodeInterpreterChange);
    }

    private void handleNodeInterpreterChange(@Nullable NodeJsInterpreter newInterpreter) {
        if (newInterpreter == null) {
            this.fireVersionUpdated(null, null);
        } else {
            Ref<SemVer> versionRef = newInterpreter.getCachedVersion();
            if (versionRef != null) {
                this.fireVersionUpdated(newInterpreter, (SemVer)versionRef.get());
            } else {
                this.fireUpdateStarted();
                ModalityState modalityState = ModalityState.any();
                newInterpreter.fetchVersion((NullableConsumer<? super SemVer>)((NullableConsumer)version -> ApplicationManager.getApplication().invokeLater(() -> this.fireVersionUpdated(newInterpreter, (SemVer)version), modalityState)));
            }
        }
    }

    private void fireUpdateStarted() {
        for (NodeVersionListener listener2 : this.myVersionListeners) {
            listener2.versionUpdateStarted();
        }
    }

    private void fireVersionUpdated(@Nullable NodeJsInterpreter interpreter, @Nullable SemVer version) {
        for (NodeVersionListener listener2 : this.myVersionListeners) {
            listener2.versionUpdated(interpreter, version);
        }
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeSettingsView.$$$reportNull$$$0(1);
        }
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
        if (this.myOneClickConfiguration) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
        }
    }

    public void setPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NodeSettingsView.$$$reportNull$$$0(2);
        }
        this.myPmPackageField.setSelectedRef(packageRef);
        if (this.myOneClickConfiguration) {
            this.myPmPackageField.setPreferredWidthToFitText();
        }
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myNodeInterpreterField.getInterpreterRef();
        if (nodeJsInterpreterRef == null) {
            NodeSettingsView.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodePackageRef getPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = this.myPmPackageField.getSelectedRef();
        if (nodePackageRef == null) {
            NodeSettingsView.$$$reportNull$$$0(4);
        }
        return nodePackageRef;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            NodeSettingsView.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeSettingsView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeSettingsView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setPackageManagerPackageRef";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

