/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ProfilingUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import java.io.File;
import java.util.ArrayList;

public class ActionCallbackProfilerStopper
extends ActionCallback {
    private static final Logger LOG = Logger.getInstance(ActionCallbackProfilerStopper.class);
    private final Project myProject;

    public ActionCallbackProfilerStopper(Project project) {
        this.myProject = project;
    }

    public void setRejected() {
        String path;
        super.setRejected();
        if (AsyncProfilerHandler.getInstance(this.myProject).isProfilingStarted()) {
            try {
                AsyncProfilerHandler.getInstance(this.myProject).stopProfiling(new ArrayList<String>());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((path = ProfilingUtil.captureCPUSnapshot()) != null) {
            new File(path).delete();
        }
        Notification errorNotification = new Notification("PerformancePlugin", MessagesBundle.message("callback.stop", new Object[0]), StringUtil.notNullize((String)this.getError()), NotificationType.ERROR);
        Notifications.Bus.notify((Notification)errorNotification, (Project)this.myProject);
        LOG.error(this.getError());
    }
}

