/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.gems;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.gems.GemsUmlDummyModel;
import com.intellij.diagram.gems.GemsUmlUtil;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.rails.associations.AssociationProperty;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Set;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class GemsUmlElementManager
extends AbstractDiagramElementManager<RClass> {
    public RClass findInDataContext(DataContext context) {
        String gemName = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        Module[] modules = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (modules.length != 1) {
            return null;
        }
        Module module = modules[0];
        NamedLibraryElement[] data = (NamedLibraryElement[])context.getData(NamedLibraryElement.ARRAY_DATA_KEY);
        if (data != null && data.length == 1) {
            NamedLibraryElement library = data[0];
            String libName = library.getName();
            gemName = GemsUmlUtil.getExactGemName(libName);
        }
        if (gemName == null) {
            return null;
        }
        GemInfo gem = GemSearchUtil.findGem((Module)module, gemName);
        if (gem == null) {
            return null;
        }
        Set gems = GemManager.getAllGems((Module)module);
        VirtualFile modelsFolder = GemsUmlUtil.getModelsFolder(gem);
        GemsUmlDummyModel dummy = null;
        Set<GemInfo> dependentGems = GemsUmlUtil.getDependentGems(gem, gems);
        if (modelsFolder == null) {
            for (GemInfo dependency : dependentGems) {
                if (GemsUmlUtil.getModelsFolder(dependency) == null) continue;
                dummy = new GemsUmlDummyModel(module, gem);
            }
        } else {
            dummy = new GemsUmlDummyModel(module, gem);
        }
        if (dummy != null) {
            dummy.setDependencies(dependentGems);
        }
        return dummy;
    }

    public boolean isAcceptableAsNode(Object element) {
        return element instanceof RClass;
    }

    public String getElementTitle(RClass element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(Object element, DiagramState presentation) {
        String text = null;
        if (element instanceof RContainer && ((RContainer)element).isValid()) {
            if (element instanceof RClass) {
                Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)element));
                if (symbol != null) {
                    text = symbol.getFQNWithNesting().toString();
                }
            } else {
                text = ((RContainer)element).getName();
            }
        } else {
            text = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (element instanceof AssociationProperty ? ((AssociationProperty)element).getName() : "");
        }
        if (text == null) {
            text = element.toString();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public String getNodeTooltip(RClass element) {
        return element.getName();
    }
}

