/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RegExpCompletionContributor
extends CompletionContributor {
    private static final Icon emptyIcon = EmptyIcon.create((Icon)PlatformIcons.PROPERTY_ICON);

    public RegExpCompletionContributor() {
        PsiElementPattern.Capture namedCharacterPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("\\N");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)namedCharacterPattern), new NamedCharacterCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.LBRACE).afterLeaf((ElementPattern)namedCharacterPattern)), new NamedCharacterCompletionProvider(false));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withText("\\I"), new CharacterClassesNameCompletionProvider());
        PsiElementPattern propertyPattern = PlatformPatterns.psiElement().withText("\\p");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern), new PropertyCompletionProvider());
        PsiElementPattern propertyNamePattern = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).afterLeaf((ElementPattern)propertyPattern));
        this.extend(CompletionType.BASIC, (ElementPattern)propertyNamePattern, new PropertyNameCompletionProvider());
        PsiElementPattern bracketExpressionPattern = PlatformPatterns.psiElement().afterLeaf(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)RegExpTT.BRACKET_EXPRESSION_BEGIN), PlatformPatterns.psiElement((IElementType)RegExpTT.CARET).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.BRACKET_EXPRESSION_BEGIN))}));
        this.extend(CompletionType.BASIC, (ElementPattern)bracketExpressionPattern, new BracketExpressionCompletionProvider());
        namedCharacterPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("\\\\N");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)namedCharacterPattern), new NamedCharacterCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.LBRACE).afterLeaf((ElementPattern)namedCharacterPattern)), new NamedCharacterCompletionProvider(false));
        PsiElementPattern backSlashPattern = PlatformPatterns.psiElement().withText("\\\\I");
        this.extend(CompletionType.BASIC, (ElementPattern)backSlashPattern, new CharacterClassesNameCompletionProvider());
        PsiElementPattern propertyPattern2 = PlatformPatterns.psiElement().withText("\\\\p");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern2), new PropertyCompletionProvider());
        PsiElementPattern propertyNamePattern2 = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).afterLeaf((ElementPattern)propertyPattern2));
        this.extend(CompletionType.BASIC, (ElementPattern)propertyNamePattern2, new PropertyNameCompletionProvider());
        PsiElementPattern backSlashPattern2 = PlatformPatterns.psiElement().withText("\\\\");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)backSlashPattern2), new CharacterClassesNameCompletionProvider());
        propertyPattern = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("p")).afterLeaf((ElementPattern)backSlashPattern2);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)propertyPattern), new PropertyCompletionProvider());
        propertyNamePattern = PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("{")).afterLeaf((ElementPattern)propertyPattern));
        this.extend(CompletionType.BASIC, (ElementPattern)propertyNamePattern, new PropertyNameCompletionProvider());
        PsiElementPattern.Capture namedCharacterPattern2 = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("N");
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)namedCharacterPattern2), new NamedCharacterCompletionProvider(true));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)RegExpTT.LBRACE).afterLeaf((ElementPattern)namedCharacterPattern2)), new NamedCharacterCompletionProvider(false));
    }

    private static void addLookupElement(CompletionResultSet result2, @NonNls String name, String type, Icon icon) {
        result2.addElement(RegExpCompletionContributor.createLookupElement(name, type, icon));
    }

    private static LookupElement createLookupElement(String name, String type, Icon icon) {
        return LookupElementBuilder.create((String)name).withTypeText(type).withIcon(icon);
    }

    private static class NamedCharacterCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final boolean myEmbrace;

        NamedCharacterCompletionProvider(boolean embrace) {
            this.myEmbrace = embrace;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                NamedCharacterCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                NamedCharacterCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                NamedCharacterCompletionProvider.$$$reportNull$$$0(2);
            }
            UnicodeCharacterNames.iterate(name -> {
                if (result2 == null) {
                    NamedCharacterCompletionProvider.$$$reportNull$$$0(3);
                }
                if (result2.getPrefixMatcher().prefixMatches(name)) {
                    String type = new String(new int[]{UnicodeCharacterNames.getCodePoint(name)}, 0, 1);
                    if (this.myEmbrace) {
                        result2.addElement(RegExpCompletionContributor.createLookupElement("{" + name + "}", type, emptyIcon));
                    } else {
                        result2.addElement(TailTypeDecorator.withTail(RegExpCompletionContributor.createLookupElement(name, type, emptyIcon), TailType.createSimpleTailType((char)'}')));
                    }
                }
                ProgressManager.checkCanceled();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$NamedCharacterCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$addCompletions$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CharacterClassesNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private CharacterClassesNameCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                CharacterClassesNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CharacterClassesNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                CharacterClassesNameCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] completion : RegExpLanguageHosts.getInstance().getKnownCharacterClasses(parameters.getPosition())) {
                RegExpCompletionContributor.addLookupElement(result2, completion[0], completion[1], emptyIcon);
            }
            for (String[] stringArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(parameters.getPosition())) {
                RegExpCompletionContributor.addLookupElement(result2, "p{" + stringArray[0] + "}", stringArray.length > 1 ? stringArray[1] : null, PlatformIcons.PROPERTY_ICON);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$CharacterClassesNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PropertyCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                PropertyCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PropertyCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                PropertyCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] stringArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(parameters.getPosition())) {
                RegExpCompletionContributor.addLookupElement(result2, "{" + stringArray[0] + "}", stringArray.length > 1 ? stringArray[1] : null, PlatformIcons.PROPERTY_ICON);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$PropertyCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyNameCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PropertyNameCompletionProvider() {
        }

        public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                PropertyNameCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PropertyNameCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                PropertyNameCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] stringArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(parameters.getPosition())) {
                result2.addElement(TailTypeDecorator.withTail(RegExpCompletionContributor.createLookupElement(stringArray[0], null, emptyIcon), TailType.createSimpleTailType((char)'}')));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$PropertyNameCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BracketExpressionCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private BracketExpressionCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                BracketExpressionCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BracketExpressionCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                BracketExpressionCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String[] completion : RegExpLanguageHosts.getInstance().getPosixCharacterClasses(parameters.getPosition())) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)completion[0]).withTypeText(completion.length > 1 ? completion[1] : null).withIcon(emptyIcon).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        context.setAddCompletionChar(false);
                        Editor editor = context.getEditor();
                        Document document = editor.getDocument();
                        int tailOffset = context.getTailOffset();
                        if (document.getTextLength() < tailOffset + 2 || !document.getText(new TextRange(tailOffset, tailOffset + 2)).equals(":]")) {
                            document.insertString(tailOffset, (CharSequence)":]");
                        }
                        editor.getCaretModel().moveCaretRelatively(2, 0, false, false, true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$BracketExpressionCompletionProvider$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/RegExpCompletionContributor$BracketExpressionCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

