/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.typescript.intentions.TypeScriptReferencesLibraryFix;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class TypeScriptReferencePathValidatorImpl
implements TypeScriptReferencePathValidator {
    public static final TypeScriptReferencePathValidator INSTANCE = new TypeScriptReferencePathValidatorImpl();
    private static final Key<ParameterizedCachedValue<List<VirtualFile>, JSFile>> OUT_OF_PROJECT_REFERENCES_KEY = Key.create((String)"TS.FILES.OUT.OF.PROJECT.REFS");
    private static final ParameterizedCachedValueProvider<List<VirtualFile>, JSFile> OUT_OF_PROJECT_REFERENCES_PROVIDER = new ParameterizedCachedValueProvider<List<VirtualFile>, JSFile>(){

        public CachedValueProvider.Result<List<VirtualFile>> compute(JSFile file2) {
            Project project = file2.getProject();
            Object[] includedFiles = FileIncludeManager.getManager((Project)project).getIncludedFiles(file2.getVirtualFile(), true, true);
            if (includedFiles.length == 0) {
                return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{file2});
            }
            GlobalSearchScope scope = TypeScriptReferencePathValidatorImpl.getAllScope(file2);
            List outOfProjectFiles = ContainerUtil.filter((Object[])includedFiles, file1 -> !scope.accept(file1) && TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file1.getFileType()));
            ArrayList depends = ContainerUtil.newArrayListWithCapacity((int)(outOfProjectFiles.size() + 1));
            depends.add(file2);
            depends.addAll(outOfProjectFiles);
            return CachedValueProvider.Result.create((Object)outOfProjectFiles, (Collection)depends);
        }
    };

    @Override
    public boolean hasOutOfProjectReferences(@NotNull JSFile file2) {
        if (file2 == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(0);
        }
        return !this.getOutOfProjectReferences(file2).isEmpty();
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getOutOfProjectReferences(@NotNull JSFile file2) {
        List value;
        if (file2 == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(1);
        }
        List list = (value = (List)CachedValuesManager.getManager((Project)file2.getProject()).getParameterizedCachedValue((UserDataHolder)file2, OUT_OF_PROJECT_REFERENCES_KEY, OUT_OF_PROJECT_REFERENCES_PROVIDER, false, (Object)file2)) == null ? ContainerUtil.emptyList() : value;
        if (list == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void checkReferences(@NotNull PsiComment comment, @NotNull AnnotationHolder holder, boolean error) {
        PsiElement parent;
        if (comment == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(4);
        }
        if (!((parent = comment.getParent()) instanceof JSFile)) {
            return;
        }
        JSFile file2 = (JSFile)parent;
        if (!this.hasOutOfProjectReferences(file2)) {
            return;
        }
        GlobalSearchScope scope = TypeScriptReferencePathValidatorImpl.getAllScope(file2);
        if (!scope.accept(((JSFile)parent).getVirtualFile())) {
            return;
        }
        Matcher matcher = TypeScriptReferenceContributor.TYPESCRIPT_REFERENCE_PATH.matcher(comment.getText());
        if (!matcher.matches()) {
            return;
        }
        boolean valid = true;
        for (PsiReference reference : comment.getReferences()) {
            PsiElement resolve;
            if (reference instanceof FileReference && !((FileReference)reference).isLast() || !((resolve = reference.resolve()) instanceof JSFile) || !DialectDetector.isTypeScript(resolve)) continue;
            JSFile resolvedFile = (JSFile)resolve;
            if (!scope.accept(resolvedFile.getVirtualFile())) {
                valid = false;
                break;
            }
            if (!this.hasOutOfProjectReferences(resolvedFile)) continue;
            valid = false;
            error = false;
            break;
        }
        if (!valid) {
            this.createErrorAnnotationWithQuickFix(file2, comment, holder, error);
        }
    }

    @NotNull
    private static GlobalSearchScope getAllScope(@NotNull JSFile file2) {
        if (file2 == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(5);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)file2.getProject());
        if (globalSearchScope == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    public void createErrorAnnotationWithQuickFix(@NotNull JSFile file2, @NotNull PsiComment host, @NotNull AnnotationHolder holder, boolean error) {
        if (file2 == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(7);
        }
        if (host == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            TypeScriptReferencePathValidatorImpl.$$$reportNull$$$0(9);
        }
        Collection<VirtualFile> files = this.getOutOfProjectReferences(file2);
        assert (!files.isEmpty());
        new JSAnnotatorProblemReporter(holder).registerProblem((PsiElement)host, "The reference includes files outside the project", error ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.WEAK_WARNING, new TypeScriptReferencesLibraryFix((PsiElement)host));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptReferencePathValidatorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfProjectReferences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasOutOfProjectReferences";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOutOfProjectReferences";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotationWithQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

