/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeMemberParser {
    @Nullable
    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(0);
        }
        if (TypeScriptTypeMemberParser.isEmptySubstitutor(typeSubstitutor)) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty((PsiElement)member)) {
                return null;
            }
            return member;
        }
        JSRecordType.TypeMember typeMember = null;
        if (member instanceof TypeScriptPropertySignature) {
            typeMember = TypeScriptTypeMemberParser.copyPropertySignature((TypeScriptPropertySignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptFunctionSignature) {
            typeMember = TypeScriptTypeMemberParser.copyFunctionSignature((TypeScriptFunctionSignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptCallSignature) {
            typeMember = TypeScriptTypeMemberParser.copyCallSignature((TypeScriptCallSignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptIndexSignature) {
            typeMember = TypeScriptTypeMemberParser.copyIndexSignature((TypeScriptIndexSignature)member, typeSubstitutor);
        }
        return typeMember;
    }

    static boolean isEmptySubstitutor(@Nullable JSTypeSubstitutor typeSubstitutor) {
        return typeSubstitutor == null || typeSubstitutor == JSTypeSubstitutor.EMPTY || typeSubstitutor.isEmpty();
    }

    @NotNull
    private static JSRecordType.TypeMember copyIndexSignature(@NotNull TypeScriptIndexSignature indexSignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (indexSignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(1);
        }
        JSType signatureType = indexSignature.getMemberType();
        JSType parameterType = indexSignature.getMemberParameterType();
        JSRecordTypeImpl.IndexSignatureImpl indexSignatureImpl = new JSRecordTypeImpl.IndexSignatureImpl(JSTypeUtils.applyGenericArguments(parameterType, typeSubstitutor), JSTypeUtils.applyGenericArguments(signatureType, typeSubstitutor), (PsiElement)indexSignature);
        if (indexSignatureImpl == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(2);
        }
        return indexSignatureImpl;
    }

    @NotNull
    private static JSRecordType.TypeMember copyCallSignature(@NotNull TypeScriptCallSignature member, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSRecordTypeImpl.CallSignatureImpl typeMember;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(3);
        }
        JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)JSTypeUtils.applyGenericArguments((JSType)member.getFunctionType(), typeSubstitutor);
        JSRecordTypeImpl.CallSignatureImpl callSignatureImpl = typeMember = new JSRecordTypeImpl.CallSignatureImpl(member.isConstructor(), functionType);
        if (callSignatureImpl == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(4);
        }
        return callSignatureImpl;
    }

    @Nullable
    private static JSRecordType.TypeMember copyFunctionSignature(@NotNull TypeScriptFunctionSignature functionSignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String name;
        if (functionSignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)(name = functionSignature.getMemberName()))) {
            return null;
        }
        JSType type = JSTypeUtils.applyGenericArguments(functionSignature.getType(), typeSubstitutor);
        return new JSRecordTypeImpl.PropertySignatureImpl(name, type, functionSignature.isOptional(), (PsiElement)functionSignature);
    }

    @Nullable
    private static JSRecordType.TypeMember copyPropertySignature(@NotNull TypeScriptPropertySignature propertySignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (propertySignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(6);
        }
        JSType type = propertySignature.getType();
        String name = propertySignature.getMemberName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(name, JSTypeUtils.applyGenericArguments(type, typeSubstitutor), propertySignature.isOptional(), (PsiElement)propertySignature);
    }

    static boolean isPropertyNameEmpty(@NotNull PsiElement member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(7);
        }
        return member instanceof JSRecordType.PropertySignature && StringUtil.isEmpty((String)((JSRecordType.PropertySignature)member).getMemberName());
    }

    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(8);
        }
        return TypeScriptTypeMemberParser.buildTypeMember(member, JSTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JSRecordType.TypeMember buildTypeMemberFromClassMember(@NotNull JSClass ownerClass, @NotNull JSElement member, boolean isStatic, @NotNull JSTypeSource source, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (ownerClass == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(9);
        }
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(10);
        }
        if (source == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(11);
        }
        if (JSResolveUtil.isConstructorFunction((PsiElement)member)) {
            if (isStatic) {
                JSType constructorReturnType = TypeScriptTypeParser.createConstructorReturnType(ownerClass, source);
                TypeScriptJSFunctionTypeImpl functionType = TypeScriptTypeParser.buildFunctionTypeImpl((JSFunctionItem)((JSFunction)member), constructorReturnType);
                TypeScriptJSFunctionTypeImpl type = (TypeScriptJSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(functionType, typeSubstitutor);
                return new JSRecordTypeImpl.CallSignatureImpl(true, type);
            }
            return null;
        }
        if (!TypeScriptTypeMemberParser.checkStatics((PsiElement)member, isStatic)) {
            return null;
        }
        if (member instanceof TypeScriptTypeMember) {
            return TypeScriptTypeMemberParser.buildTypeMember((TypeScriptTypeMember)member, typeSubstitutor);
        }
        if (TypeScriptTypeMemberParser.isEmptySubstitutor(typeSubstitutor) && member instanceof JSRecordType.TypeMember) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty((PsiElement)member)) {
                return null;
            }
            return (JSRecordType.TypeMember)member;
        }
        String name = member.getName();
        if (name == null && member instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)member);
        }
        if (name == null) {
            return null;
        }
        JSType typeForProperty = TypeScriptTypeParser.buildTypeFromClassMember((PsiElement)member);
        JSType type = JSTypeUtils.applyGenericArguments(typeForProperty, typeSubstitutor);
        boolean optional = member instanceof JSOptionalOwner && ((JSOptionalOwner)member).isOptional();
        return new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional, (PsiElement)member);
    }

    private static boolean checkStatics(@NotNull PsiElement member, boolean isStatic) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(12);
        }
        if (!(member instanceof JSElementBase)) {
            return true;
        }
        JSContext context = ((JSElementBase)member).getJSContext();
        boolean isContextStatic = context == JSContext.STATIC;
        return isStatic == isContextStatic;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSignature";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSignature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyIndexSignature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copyCallSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMember";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyIndexSignature";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyCallSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyFunctionSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertySignature";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyNameEmpty";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMemberFromClassMember";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkStatics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

