/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.localization.validation;

import com.intellij.psi.PsiElement;
import com.jetbrains.localization.psi.impl.LocalePsiElement;
import com.jetbrains.localization.validation.LocaleAnnotator;

public class LocaleStringConstantAnnotator
extends LocaleAnnotator {
    public static final String MISSING_Q = "Missing closing quote";

    @Override
    public void visitStringLiteral(LocalePsiElement node) {
        String text = node.getText();
        String msg = "";
        boolean ok = true;
        int index = 0;
        if (text.length() == 0) {
            return;
        }
        char first_quote = text.charAt(index);
        if (++index >= text.length()) {
            msg = "Missing closing quote [" + first_quote + "]";
            ok = false;
        } else {
            index = text.length() - 1;
            while (text.charAt(index) == '\n') {
                --index;
            }
            if (text.charAt(index) != first_quote) {
                msg = "Missing closing quote [" + first_quote + "]";
                ok = false;
            }
        }
        if (!ok) {
            this.getHolder().createErrorAnnotation((PsiElement)node, msg);
        }
    }
}

