/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBasedSqlTableTypeImpl<T extends DasTypedObject>
extends SqlTableTypeBase {
    private final List<T> myColumns;
    private final List<PsiObject> myMethods;
    private final PsiObject myDatabaseElement;
    private final String myTableName;
    private final PsiElement myQualifier;
    private DataType myDataType;

    public TableBasedSqlTableTypeImpl(PsiObject databaseElement, @Nullable PsiElement place, Class<T> clazz, ObjectKind kind) {
        this.myDatabaseElement = databaseElement;
        this.myQualifier = TableBasedSqlTableTypeImpl.resolved(place);
        PsiElement infoPsi = DbSqlUtil.getPsiDelegate((DasObject)databaseElement);
        this.myTableName = databaseElement.getName();
        this.myDataType = DataTypeFactory.of(this.myTableName);
        this.myColumns = infoPsi == null && place == null ? ContainerUtil.newArrayList((Iterable)this.myDatabaseElement.getDasChildren(kind).filter(clazz)) : (List)ObjectUtils.notNull(TableBasedSqlTableTypeImpl.collectColumns(this.myDatabaseElement, infoPsi, place, clazz, kind), Collections.emptyList());
        List methods = this.myDatabaseElement.getDasChildren(ObjectKind.ROUTINE).filter(PsiObject.class).toList();
        this.myMethods = methods.isEmpty() ? Collections.emptyList() : methods;
    }

    public static <T extends DasTypedObject> List<T> collectColumns(PsiObject databaseElement, PsiElement psiDelegate, @Nullable PsiElement place, Class<T> clazz, ObjectKind kind) {
        return (List)SqlReferenceImpl.ourGuard.doPreventingRecursion((Object)databaseElement, true, () -> TableBasedSqlTableTypeImpl.calcColumns((DasObject)databaseElement, psiDelegate, place, clazz, kind));
    }

    @NotNull
    public DataType getDataType() {
        if (this.myDataType == null) {
            this.myDataType = SqlTypeFactory.createTableDataType(this.myColumns);
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(0);
        }
        return dataType;
    }

    public TableBasedSqlTableTypeImpl(List<T> columns, @Nullable PsiElement qualifier) {
        this.myDatabaseElement = null;
        this.myColumns = columns;
        this.myTableName = null;
        this.myQualifier = TableBasedSqlTableTypeImpl.resolved(qualifier);
        this.myMethods = Collections.emptyList();
    }

    @Nullable
    private static PsiElement resolved(@Nullable PsiElement place) {
        return (PsiElement)ObjectUtils.chooseNotNull((Object)(place instanceof SqlReferenceExpression ? ((SqlReferenceExpression)place).resolve() : place), (Object)place);
    }

    @NotNull
    public List<PsiObject> getMethods() {
        List<PsiObject> list = this.myMethods;
        if (list == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myDatabaseElement;
    }

    public int getColumnCount() {
        return this.myColumns.size();
    }

    public String getColumnName(int i2) {
        return ((DasTypedObject)this.myColumns.get(i2)).getName();
    }

    public SqlType getColumnType(int i2) {
        DasTypedObject column2 = (DasTypedObject)this.myColumns.get(i2);
        if (column2 instanceof SqlTypedDefinition) {
            return ((SqlTypedDefinition)column2).getSqlType();
        }
        return SqlTypeFactory.of(this.getDataType(i2), SqlImplUtil.getSqlDialectSafe((PsiElement)this.myDatabaseElement));
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        return this.myQualifier;
    }

    @NotNull
    public DataType getDataType(int i2) {
        DataType dataType = ((DasTypedObject)this.myColumns.get(i2)).getDataType();
        if (dataType == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(2);
        }
        return dataType;
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        PsiElement psiElement = (PsiElement)this.myColumns.get(i2);
        if (psiElement == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public PsiElement getSourceColumnElement(int i2) {
        PsiElement element2 = (PsiElement)this.myColumns.get(i2);
        return element2 instanceof FakePsiElement ? element2.getNavigationElement() : element2;
    }

    public List<T> getColumns() {
        return this.myColumns;
    }

    private static <T extends DasTypedObject> List<T> calcColumns(DasObject info, PsiElement infoPsi, PsiElement place, Class<T> clazz, ObjectKind kind) {
        ArrayList columns = ContainerUtil.newArrayList((Iterable)info.getDasChildren(kind).filter(clazz));
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(SqlImplUtil.getSqlDialectSafe(place), place == null ? Collections.emptyList() : SqlImplUtil.getDataSources(place));
        Map named = DasUtil.newCaseAwareMap((boolean)DasUtil.isCaseSensitive((Casing)casingProvider.getCasing(ObjectKind.COLUMN, info)));
        for (DasTypedObject column2 : columns) {
            named.put(column2.getName(), column2);
        }
        PsiFile file = infoPsi == null ? null : infoPsi.getContainingFile();
        PsiFile placeFile = place != null ? place.getContainingFile().getOriginalFile() : null;
        Ref checkPlace = Ref.create((Object)(file == placeFile ? 1 : 0));
        Processor processor = instruction2 -> {
            block10: {
                IElementType instructionType;
                block9: {
                    int idx;
                    if (((Boolean)checkPlace.get()).booleanValue() && !SqlDialectImplUtil.placeBefore((PsiElement)instruction2, place)) {
                        return true;
                    }
                    instructionType = instruction2.getInstructionType();
                    if (instructionType != SqlCommonKeywords.SQL_MODIFY && instructionType != SqlCommonKeywords.SQL_CHANGE && instructionType != SqlCommonKeywords.SQL_RENAME) break block9;
                    String fromName = null;
                    String toName = null;
                    DasTypedObject to = null;
                    for (PsiElement element2 : SqlImplUtil.childrenIt((PsiElement)instruction2)) {
                        SqlReferenceExpression ref;
                        if (element2 instanceof SqlTypedDefinition && clazz.isAssignableFrom(element2.getClass())) {
                            to = (DasTypedObject)clazz.cast(element2);
                            if (fromName == null) {
                                fromName = to.getName();
                            }
                            toName = to.getName();
                            break;
                        }
                        if (!(element2 instanceof SqlReferenceExpression) || (ref = (SqlReferenceExpression)element2).getReferenceElementType().getTargetKind() != kind) continue;
                        if (fromName != null) break;
                        fromName = ref.getName();
                    }
                    if (to == null || (idx = columns.indexOf(named.get(fromName))) == -1) break block10;
                    columns.set(idx, to);
                    named.remove(fromName);
                    named.put(toName, to);
                    break block10;
                }
                if (instructionType == SqlCommonKeywords.SQL_ADD) {
                    for (DasTypedObject col : SqlImplUtil.childrenIt((PsiElement)instruction2).filter(SqlTypedDefinition.class).filter(clazz)) {
                        if (named.containsKey(col.getName())) continue;
                        columns.add(col);
                        named.put(col.getName(), col);
                    }
                } else if (instructionType == SqlCommonKeywords.SQL_DROP) {
                    for (SqlReferenceExpression col : SqlImplUtil.childrenIt((PsiElement)instruction2).filter(SqlReferenceExpression.class)) {
                        if (col.getReferenceElementType().getTargetKind() != kind) continue;
                        DasTypedObject toDrop = (DasTypedObject)named.get(col.getName());
                        columns.remove(toDrop);
                        named.remove(col.getName());
                    }
                }
            }
            return true;
        };
        SqlImplUtil.processAlterStatements(file, place, info, (Processor<SqlAlterInstruction>)processor);
        if (place != null && !((Boolean)checkPlace.get()).booleanValue()) {
            checkPlace.set((Object)true);
            SqlImplUtil.processAlterStatements(place.getContainingFile(), place, info, (Processor<SqlAlterInstruction>)processor);
        }
        return columns;
    }

    @Override
    @Nullable
    public String getColumnTypeAlias(int i2) {
        return this.myTableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/psi/impl/TableBasedSqlTableTypeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

