/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ColumnMappingStrategy;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.MappingTableColumnEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportColumnEditor<T extends ColumnDescriptor>
extends DatabaseTableColumnsEditor {
    public ImportColumnEditor(@NotNull ImportDatabaseTableEditor<T> tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator decorator) {
        if (tableEditor == null) {
            ImportColumnEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            ImportColumnEditor.$$$reportNull$$$0(1);
        }
        if (decorator == null) {
            ImportColumnEditor.$$$reportNull$$$0(2);
        }
        super(tableEditor, caps, decorator);
    }

    @Override
    @NotNull
    protected DatabaseTableColumnEditor createColumnEditor(@NotNull DeColumn column2) {
        if (column2 == null) {
            ImportColumnEditor.$$$reportNull$$$0(3);
        }
        TableEditorModel model = this.getTableModel();
        ColumnEditorModel columnModel = model.modelsCache.get(column2, ColumnEditorModel.class);
        DatabaseEditorCapabilities.TableColumnEditorCaps caps = this.getTableColumnCaps(column2);
        List descriptors = ContainerUtil.filter(this.getState().getDescriptors(), (Condition)Conditions.not(this::isBusy));
        Object descriptor = ColumnMappingStrategy.map(column2, descriptors);
        MappingTableColumnEditor<T> mappingTableColumnEditor = this.subscribeAndRegister(new MappingTableColumnEditor<T>(this.getState(), model, columnModel, caps, this, descriptor));
        if (mappingTableColumnEditor == null) {
            ImportColumnEditor.$$$reportNull$$$0(4);
        }
        return mappingTableColumnEditor;
    }

    @NotNull
    public LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> getMapping() {
        LinkedHashMap map = ContainerUtilRt.newLinkedHashMap();
        List items = this.myColumnModel.getItems();
        for (DatabaseTableColumnEditor item : items) {
            MappingTableColumnEditor editor = (MappingTableColumnEditor)item;
            Object descriptor = editor.getDescriptor();
            DeColumn column2 = editor.getColumn();
            map.put(ImportUtil.createDescriptor(column2, descriptor != null), descriptor);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            ImportColumnEditor.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    void createInitialMapping() {
        JBIterable items = JBIterable.from((Iterable)this.myColumnModel.getItems()).map(item -> (MappingTableColumnEditor)item);
        items.forEach(item -> item.setDescriptor(null));
        List columns = items.map(item -> item.getColumn()).toList();
        Map map = ColumnMappingStrategy.map(columns, this.getState().getDescriptors());
        items.forEach(item -> item.setDescriptor((ColumnDescriptor)map.get(item.getColumn())));
    }

    @NotNull
    private ImportEditorState<T> getState() {
        ImportEditorState importEditorState = (ImportEditorState)this.myTableEditor.getState();
        if (importEditorState == null) {
            ImportColumnEditor.$$$reportNull$$$0(6);
        }
        return importEditorState;
    }

    private boolean isBusy(@Nullable ColumnDescriptor descriptor) {
        return descriptor != null && ContainerUtil.exists((Iterable)this.myColumnModel.getItems(), item -> ((MappingTableColumnEditor)item).getDescriptor() == descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/ImportColumnEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/ImportColumnEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createColumnEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createColumnEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

