/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import a.b.lb;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFragment {
    private static final Logger c;
    protected final PsiAnchor[] myElementAnchors;
    private final Language g;
    private PsiFragment[] f;
    private boolean e;
    private boolean d;
    private boolean b;
    private int a;
    private static final long i;

    public PsiFragment(PsiElement element) {
        this(element, 0);
    }

    public PsiFragment(PsiElement element, int cost) {
        this.myElementAnchors = new PsiAnchor[]{this.createAnchor(element)};
        this.e = false;
        this.d = false;
        this.b = false;
        this.f = null;
        this.a = cost;
        this.g = this.calcLanguage(element);
    }

    protected Language calcLanguage(PsiElement element) {
        return PsiFragment.b(element);
    }

    protected PsiAnchor createAnchor(PsiElement element) {
        return (PsiAnchor)ReadAction.compute(() -> PsiAnchor.create((PsiElement)element));
    }

    public PsiFragment(List<? extends PsiElement> elements) {
        this(elements, 0, elements.size() - 1);
    }

    public PsiFragment(List<? extends PsiElement> elements, int from, int to) {
        this.myElementAnchors = new PsiAnchor[to - from + 1];
        for (int i10 = from; i10 <= to; ++i10) {
            this.myElementAnchors[i10 - from] = this.createAnchor(elements.get(i10));
        }
        this.e = false;
        this.d = false;
        this.b = false;
        this.f = null;
        this.g = to >= from && from < elements.size() ? this.calcLanguage(elements.get(from)) : null;
    }

    @NotNull
    private static Language b(@NotNull PsiElement psiElement) {
        DuplicatesProfile duplicatesProfile;
        if (psiElement == null) {
            PsiFragment.a(0);
        }
        if ((duplicatesProfile = DuplicatesProfile.findProfileForLanguage(psiElement.getLanguage())) == null) {
            Language language = psiElement.getLanguage();
            if (language == null) {
                PsiFragment.a(1);
            }
            return language;
        }
        Language language = duplicatesProfile.getLanguage(psiElement);
        if (language == null) {
            PsiFragment.a(2);
        }
        return language;
    }

    public void setCost(int c10) {
        if (this.a != -1) {
            this.a = c10;
        }
    }

    public void markDuplicate() {
        this.e = true;
    }

    public boolean isNested() {
        if (this.d) {
            return this.b;
        }
        this.d = true;
        if (this.f != null) {
            PsiFragment psiFragment = this.f[0];
            PsiFragment psiFragment2 = this.f[1];
            if (psiFragment != null) {
                this.b |= psiFragment.e || psiFragment.isNested();
                if (psiFragment2 != null) {
                    this.b |= psiFragment2.e || psiFragment2.isNested();
                }
            }
        }
        return this.b;
    }

    public void setParent(PsiFragment f10) {
        long l3 = i ^ 0x1C04ECC9FEAAL;
        if (f10 == null) {
            return;
        }
        if (this.f == null) {
            this.f = new PsiFragment[]{f10, null};
        } else {
            if (this.f[0] == f10 || this.f[1] == f10) {
                return;
            }
            if (this.f[1] != null) {
                c.error("Third parent set.");
            }
            this.f[1] = f10;
        }
    }

    public PsiElement[] getElements() {
        PsiElement[] psiElementArray = new PsiElement[this.myElementAnchors.length];
        for (int i10 = 0; i10 < psiElementArray.length; ++i10) {
            psiElementArray[i10] = this.myElementAnchors[i10].retrieve();
        }
        return psiElementArray;
    }

    @Nullable
    public PsiFile getFile() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[0].getFile() : null;
    }

    public int getStartOffset() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[0].getStartOffset() : -1;
    }

    public int getEndOffset() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[this.myElementAnchors.length - 1].getEndOffset() : -1;
    }

    public boolean intersectsWith(PsiFragment f10) {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        int n4 = f10.getStartOffset();
        int n5 = f10.getEndOffset();
        return Comparing.equal((Object)f10.getFile(), (Object)this.getFile()) && (n2 <= n4 && n4 <= n3 || n2 <= n5 && n5 <= n3);
    }

    public boolean contains(PsiFragment f10) {
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        int n4 = f10.getStartOffset();
        int n5 = f10.getEndOffset();
        return Comparing.equal((Object)f10.getFile(), (Object)this.getFile()) && n2 <= n4 && n3 >= n5;
    }

    public abstract boolean isEqual(PsiElement[] var1, int var2);

    @Nullable
    public UsageInfo getUsageInfo() {
        if (this.myElementAnchors.length == 1) {
            PsiElement psiElement = this.myElementAnchors[0].retrieve();
            if (psiElement == null || !psiElement.isValid()) {
                return null;
            }
            return new UsageInfo(psiElement);
        }
        PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement[])this.getElements());
        if (psiElement == null) {
            return null;
        }
        int n2 = psiElement.getTextRange().getStartOffset();
        int n3 = this.getStartOffset() - n2;
        int n4 = this.getEndOffset() - n2;
        if (n3 < 0) {
            return null;
        }
        if (n4 < n3) {
            return null;
        }
        return new UsageInfo(psiElement, n3, n4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PsiAnchor psiAnchor : this.myElementAnchors) {
            PsiElement psiElement = psiAnchor.retrieve();
            if (psiElement == null) continue;
            stringBuilder.append(psiElement.getText());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof PsiFragment)) {
            return false;
        }
        PsiFragment psiFragment = (PsiFragment)o2;
        return psiFragment.getStartOffset() == this.getStartOffset() && psiFragment.getEndOffset() == this.getEndOffset() && Comparing.equal((Object)psiFragment.getFile(), (Object)this.getFile());
    }

    public int hashCode() {
        int n2 = this.getStartOffset();
        n2 += 31 * n2 + this.getEndOffset();
        PsiFile psiFile = this.getFile();
        if (psiFile != null) {
            n2 += 31 * n2 + psiFile.getName().hashCode();
        }
        return n2;
    }

    public int getCost() {
        return this.a;
    }

    public int[][] getOffsets() {
        int[][] nArray = new int[this.myElementAnchors.length][2];
        int n2 = 0;
        for (PsiAnchor psiAnchor : this.myElementAnchors) {
            nArray[n2][0] = psiAnchor.getStartOffset();
            nArray[n2++][1] = psiAnchor.getEndOffset();
        }
        return nArray;
    }

    public boolean containsMultipleFragments() {
        return this.myElementAnchors.length > 1;
    }

    @Nullable
    public Language getLanguage() {
        return this.g;
    }

    static {
        i = lb.a(2954515500275838753L, -8105667736743239134L, MethodHandles.lookup().lookupClass()).a(204270014876541L);
        long l3 = i ^ 0x4DA4FBB8E961L;
        c = Logger.getInstance((String)"#com.intellij.dupLocator.PsiFragment");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l3 = i ^ 0x42F8D878F385L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/util/PsiFragment";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/util/PsiFragment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLanguageForElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetLanguageForElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

