/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathLexer;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.FunctionImpl;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.Nullable;

public class FunctionDeclarationParsing {
    public static final String FUNCTION_NAMESPACE = "http://www.w3.org/2005/xpath-functions";

    private FunctionDeclarationParsing() {
    }

    public static Pair<String, ? extends Function> parseFuntionDeclaration(String decl) {
        XPath2SequenceType.Cardinality indicator;
        FilterLexer lexer = new FilterLexer(XPathLexer.create(true), (FilterLexer.Filter)new FilterLexer.SetFilter(TokenSet.create((IElementType[])new IElementType[]{XPathTokenTypes.WHITESPACE})));
        lexer.start((CharSequence)decl);
        String prefix = "";
        if (lexer.getTokenType() == XPathTokenTypes.EXT_PREFIX) {
            prefix = lexer.getTokenText();
            lexer.advance();
            FunctionDeclarationParsing.match((Lexer)lexer, XPathTokenTypes.COL);
        }
        String name = FunctionDeclarationParsing.match((Lexer)lexer, XPathTokenTypes.FUNCTION_NAME);
        FunctionDeclarationParsing.match((Lexer)lexer, XPathTokenTypes.LPAREN);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        while (lexer.getTokenType() != XPathTokenTypes.RPAREN) {
            if (lexer.getTokenType() == XPathTokenTypes.DOTDOT) {
                lexer.advance();
                FunctionDeclarationParsing.match((Lexer)lexer, XPathTokenTypes.DOT);
                parameters.add(new Parameter(XPathType.ANY, Parameter.Kind.VARARG));
            } else {
                FunctionDeclarationParsing.match((Lexer)lexer, XPathTokenTypes.DOLLAR);
                FunctionDeclarationParsing.match((Lexer)lexer, XPathTokenTypes.VARIABLE_NAME);
                FunctionDeclarationParsing.match((Lexer)lexer, XPath2TokenTypes.AS);
                String type = FunctionDeclarationParsing.parseType((Lexer)lexer);
                indicator = FunctionDeclarationParsing.parseCardinality((Lexer)lexer);
                parameters.add(new Parameter(FunctionDeclarationParsing.mapType(type, indicator), Parameter.Kind.REQUIRED));
            }
            if (lexer.getTokenType() != XPathTokenTypes.COMMA) continue;
            lexer.advance();
        }
        lexer.advance();
        FunctionDeclarationParsing.match((Lexer)lexer, XPath2TokenTypes.AS);
        String ret = FunctionDeclarationParsing.parseType((Lexer)lexer);
        indicator = FunctionDeclarationParsing.parseCardinality((Lexer)lexer);
        XPathType returnType = FunctionDeclarationParsing.mapType(ret, indicator);
        return Pair.create((Object)prefix, (Object)new FunctionImpl(name, returnType, parameters.toArray(new Parameter[0])));
    }

    public static XPathType mapType(String type, XPath2SequenceType.Cardinality c) {
        if ("none".equals(type)) {
            return XPathType.UNKNOWN;
        }
        XPathType r = null;
        if ("numeric".equals(type)) {
            r = XPath2Type.NUMERIC;
        } else if (type.startsWith("xs:")) {
            String base = type.substring(3);
            r = XPath2Type.fromName(new QName("http://www.w3.org/2001/XMLSchema", base));
            if (r == null) {
                r = XPathType.fromString(base);
            }
        } else if (type.endsWith("()")) {
            r = XPath2Type.fromName(new QName("", type));
        }
        if (r != null) {
            if (c != null) {
                r = XPath2SequenceType.create(r, c);
            }
            return r;
        }
        return XPathType.fromString(type);
    }

    @Nullable
    public static XPath2SequenceType.Cardinality parseCardinality(Lexer lexer) {
        if (lexer.getTokenType() == XPath2TokenTypes.QUEST) {
            lexer.advance();
            return XPath2SequenceType.Cardinality.OPTIONAL;
        }
        if (lexer.getTokenType() == XPathTokenTypes.MULT || lexer.getTokenType() == XPathTokenTypes.STAR) {
            lexer.advance();
            return XPath2SequenceType.Cardinality.ZERO_OR_MORE;
        }
        if (lexer.getTokenType() == XPathTokenTypes.PLUS) {
            lexer.advance();
            return XPath2SequenceType.Cardinality.ONE_OR_MORE;
        }
        return null;
    }

    public static String match(Lexer lexer, IElementType token) {
        assert (lexer.getTokenType() == token) : lexer.getTokenType() + ": " + lexer.getTokenText();
        String s = lexer.getTokenText();
        lexer.advance();
        return s;
    }

    @Nullable
    public static String parseType(Lexer lexer) {
        String type = FunctionDeclarationParsing.parseQName(lexer);
        if (type == null) {
            if (lexer.getTokenType() == XPath2TokenTypes.ITEM || lexer.getTokenType() == XPathTokenTypes.FUNCTION_NAME || lexer.getTokenType() == XPathTokenTypes.NODE_TYPE) {
                type = lexer.getTokenText();
                lexer.advance();
                FunctionDeclarationParsing.match(lexer, XPathTokenTypes.LPAREN);
                FunctionDeclarationParsing.match(lexer, XPathTokenTypes.RPAREN);
                type = type + "()";
            } else assert (false) : "unexpected token: " + lexer.getTokenType();
        }
        return type;
    }

    @Nullable
    public static String parseQName(Lexer lexer) {
        String name;
        if (lexer.getTokenType() == XPathTokenTypes.NCNAME) {
            name = lexer.getTokenText();
            lexer.advance();
            if (lexer.getTokenType() == XPathTokenTypes.COL) {
                lexer.advance();
                assert (lexer.getTokenType() == XPathTokenTypes.NCNAME);
                name = name + ":" + lexer.getTokenText();
                lexer.advance();
            }
        } else {
            name = null;
        }
        return name;
    }

    public static void addFunction(Map<Pair<QName, Integer>, Function> decls, String s) {
        Pair<String, ? extends Function> pair = FunctionDeclarationParsing.parseFuntionDeclaration(s);
        Function func = (Function)pair.second;
        boolean fn = ((String)pair.first).equals("fn") || ((String)pair.first).length() == 0;
        boolean xs = ((String)pair.first).equals("xs");
        Pair key = Pair.create((Object)new QName(fn ? FUNCTION_NAMESPACE : (xs ? "http://www.w3.org/2001/XMLSchema" : null), func.getName()), (Object)func.getParameters().length);
        assert (!decls.containsKey(key)) : key;
        decls.put((Pair<QName, Integer>)key, func);
        if (fn) {
            decls.put((Pair<QName, Integer>)Pair.create((Object)new QName(null, func.getName()), (Object)func.getParameters().length), func);
        }
    }
}

