/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.rewriting;

import com.intellij.lang.apacheConfig.rewriting.UrlRewriteEngine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RewriteRule {
    private static final Logger LOG = Logger.getInstance(UrlRewriteEngine.class);
    private final Pattern myPattern;
    private final String myReplacement;

    public RewriteRule(@NotNull String pattern, @Nullable String replacement) {
        if (pattern == null) {
            RewriteRule.$$$reportNull$$$0(0);
        }
        this.myReplacement = replacement;
        this.myPattern = Pattern.compile(pattern);
    }

    @NotNull
    public Pattern getPattern() {
        Pattern pattern = this.myPattern;
        if (pattern == null) {
            RewriteRule.$$$reportNull$$$0(1);
        }
        return pattern;
    }

    @Nullable
    public String getReplacement() {
        return this.myReplacement;
    }

    public boolean canBeApplied(String url) {
        return this.myPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)url, (long)100L)).matches();
    }

    @Nullable
    public String apply(String url) {
        if (StringUtil.isEmpty((String)this.myReplacement)) {
            return null;
        }
        try {
            return this.myPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)url, (long)100L)).replaceFirst(this.myReplacement);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fail to apply rewrite rule '" + this.myPattern.pattern() + " -> " + this.myReplacement + "' for '" + url + "'");
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/apacheConfig/rewriting/RewriteRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/apacheConfig/rewriting/RewriteRule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

