/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import icons.SvnIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public final class ConflictState
extends Enum<ConflictState> {
    public static final /* enum */ ConflictState none = new ConflictState(false, false, false, null);
    public static final /* enum */ ConflictState tree = new ConflictState(true, false, false, SvnIcons.Conflictc);
    public static final /* enum */ ConflictState text = new ConflictState(false, true, false, SvnIcons.Conflictt);
    public static final /* enum */ ConflictState prop = new ConflictState(false, false, true, SvnIcons.Conflictp);
    public static final /* enum */ ConflictState tree_text = new ConflictState(true, true, false, SvnIcons.Conflictct);
    public static final /* enum */ ConflictState tree_prop = new ConflictState(true, false, true, SvnIcons.Conflictcp);
    public static final /* enum */ ConflictState text_prop = new ConflictState(false, true, true, SvnIcons.Conflicttp);
    public static final /* enum */ ConflictState all3 = new ConflictState(true, true, true, SvnIcons.Conflictctp);
    private final boolean myTree;
    private final boolean myText;
    private final boolean myProperty;
    @Nullable
    private final Icon myIcon;
    private final String myDescription;
    private static final /* synthetic */ ConflictState[] $VALUES;

    public static ConflictState[] values() {
        return (ConflictState[])$VALUES.clone();
    }

    public static ConflictState valueOf(String name) {
        return Enum.valueOf(ConflictState.class, name);
    }

    private ConflictState(boolean tree, @Nullable boolean text, boolean property, Icon icon) {
        this.myTree = tree;
        this.myText = text;
        this.myProperty = property;
        this.myIcon = icon;
        this.myDescription = this.createDescription();
    }

    @Nullable
    private String createDescription() {
        int cnt = 0;
        StringBuilder sb = new StringBuilder();
        cnt = ConflictState.checkOne(this.myTree, cnt, sb, "tree");
        cnt = ConflictState.checkOne(this.myText, cnt, sb, "text");
        if ((cnt = ConflictState.checkOne(this.myProperty, cnt, sb, "property")) == 0) {
            return null;
        }
        return sb.toString();
    }

    private static int checkOne(boolean value, int init, StringBuilder sb, String text) {
        if (value) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(text);
            return init + 1;
        }
        return init;
    }

    public boolean isTree() {
        return this.myTree;
    }

    public boolean isText() {
        return this.myText;
    }

    public boolean isProperty() {
        return this.myProperty;
    }

    public boolean isConflict() {
        return this.myProperty || this.myText || this.myTree;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public static ConflictState mergeState(ConflictState leftState, ConflictState rightState) {
        return ConflictState.getInstance(leftState.myTree | rightState.myTree, leftState.myText | rightState.myText, leftState.myProperty | rightState.myProperty);
    }

    @NotNull
    public static ConflictState getInstance(boolean tree, boolean text, boolean property) {
        ConflictState[] conflictStates;
        for (ConflictState state : conflictStates = ConflictState.values()) {
            if (state.isTree() != tree || state.isText() != text || state.isProperty() != property) continue;
            ConflictState conflictState = state;
            if (conflictState == null) {
                ConflictState.$$$reportNull$$$0(0);
            }
            return conflictState;
        }
        assert (false);
        if (null == null) {
            ConflictState.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public static ConflictState from(@NotNull Status status) {
        if (status == null) {
            ConflictState.$$$reportNull$$$0(2);
        }
        ConflictState conflictState = ConflictState.getInstance(status.getTreeConflict() != null, StatusType.STATUS_CONFLICTED == status.getContentsStatus(), status.isProperty(StatusType.STATUS_CONFLICTED));
        if (conflictState == null) {
            ConflictState.$$$reportNull$$$0(3);
        }
        return conflictState;
    }

    static {
        $VALUES = new ConflictState[]{none, tree, text, prop, tree_text, tree_prop, text_prop, all3};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/ConflictState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/ConflictState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

