/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug;

import com.google.common.io.CountingInputStream;
import com.jetbrains.php.profiler.PhpSnapshotFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XdebugProfilerSnapshotReader {
    @NotNull
    private final BufferedReader myReader;
    private final long FILE_SIZE;
    private final CountingInputStream dataInputStream;
    private final CountingInputStream progressBarInputStream;

    public XdebugProfilerSnapshotReader(@NotNull CountingInputStream inputStream, @NotNull CountingInputStream progressBarCountingStream, long fileSize) {
        if (inputStream == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(0);
        }
        if (progressBarCountingStream == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(1);
        }
        this.myReader = new BufferedReader(new InputStreamReader((InputStream)inputStream), 0x100000);
        this.dataInputStream = inputStream;
        this.progressBarInputStream = progressBarCountingStream;
        this.FILE_SIZE = fileSize;
    }

    @Nullable
    public String rawNextLine() throws IOException {
        return this.myReader.readLine();
    }

    @NotNull
    public String nextLine() throws IOException {
        String line = this.rawNextLine();
        if (line == null) {
            throw new IOException("Unexpected stream end");
        }
        String string = line;
        if (string == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(2);
        }
        return string;
    }

    public double getFraction() {
        return (double)this.progressBarInputStream.getCount() / (double)this.FILE_SIZE;
    }

    public long getOffset() {
        return this.dataInputStream.getCount();
    }

    @NotNull
    public String parseNextLine(@NotNull String prefix, @NotNull String errorMessage) throws IOException, PhpSnapshotFormatException {
        if (prefix == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(3);
        }
        if (errorMessage == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(4);
        }
        String string = XdebugProfilerSnapshotReader.parseLine(this.nextLine(), prefix, errorMessage);
        if (string == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String parseLine(@NotNull String line, @NotNull String prefix, @NotNull String errorMessage) throws PhpSnapshotFormatException {
        if (line == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(7);
        }
        if (errorMessage == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(8);
        }
        if (line.startsWith(prefix)) {
            String string = line.substring(prefix.length());
            if (string == null) {
                XdebugProfilerSnapshotReader.$$$reportNull$$$0(9);
            }
            return string;
        }
        throw new PhpSnapshotFormatException(errorMessage + "(" + line + ")");
    }

    @Nullable
    public static String tryParseLine(@NotNull String line, @NotNull String prefix) {
        if (line == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            XdebugProfilerSnapshotReader.$$$reportNull$$$0(11);
        }
        if (line.startsWith(prefix)) {
            return line.substring(prefix.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressBarCountingStream";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/xdebug/XdebugProfilerSnapshotReader";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/xdebug/XdebugProfilerSnapshotReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "nextLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNextLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseNextLine";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryParseLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

