/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPassByRefInspection
extends PhpInspection {
    private static final String DESCRIPTION = "Only variables can be passed by reference";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PsiElement function = reference.resolve();
                if (function instanceof Function) {
                    this.checkCall((ParameterListOwner)reference, (Function)function);
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                PsiElement function = reference.resolve();
                if (function instanceof Function) {
                    this.checkCall((ParameterListOwner)reference, (Function)function);
                }
            }

            public void visitPhpNewExpression(NewExpression expression) {
                PsiElement resolve;
                ClassReference classReference = expression.getClassReference();
                if (classReference != null && (resolve = classReference.resolve()) != null) {
                    Method method;
                    Object object = resolve instanceof Method ? (Method)resolve : (method = resolve instanceof PhpClass && resolve.isValid() ? ((PhpClass)resolve).getConstructor() : null);
                    if (method != null) {
                        this.checkCall((ParameterListOwner)expression, (Function)method);
                    }
                }
            }

            private void checkCall(@NotNull ParameterListOwner reference, @NotNull Function function) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (function == null) {
                    1.$$$reportNull$$$0(1);
                }
                Parameter[] parameters = function.getParameters();
                PsiElement[] callParams = reference.getParameters();
                int length = Math.min(parameters.length, callParams.length);
                for (int i = 0; i < length; ++i) {
                    if (!parameters[i].isPassByRef() || PhpPassByRefInspection.canBePassByReference(callParams[i])) continue;
                    holder.registerProblem(callParams[i], PhpPassByRefInspection.DESCRIPTION, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "function";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection$1";
                objectArray[2] = "checkCall";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpPassByRefInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static boolean canBePassByReference(@Nullable PsiElement parameter) {
        FieldReference reference;
        if (parameter == null || parameter.getTextLength() <= 0) {
            return true;
        }
        if (PhpPsiUtil.isOfType(parameter.getPrevSibling(), PhpTokenTypes.opVARIADIC)) {
            return true;
        }
        if (parameter instanceof UnaryExpression) {
            PsiElement operation = ((UnaryExpression)parameter).getOperation();
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)operation);
            return elementType == PhpTokenTypes.kwCLONE || elementType == PhpTokenTypes.opSILENCE || (elementType == PhpTokenTypes.opDECREMENT || elementType == PhpTokenTypes.opINCREMENT) && operation == parameter.getFirstChild();
        }
        if (parameter instanceof TernaryExpression) {
            TernaryExpression ternaryExpression = (TernaryExpression)parameter;
            PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
            PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
            return PhpPassByRefInspection.canBePassByReference((PsiElement)trueVariant) && PhpPassByRefInspection.canBePassByReference((PsiElement)falseVariant);
        }
        if (parameter instanceof FieldReference && (!(reference = (FieldReference)parameter).isConstant() || reference.getReferenceType().isDynamic())) {
            return true;
        }
        return parameter instanceof Variable || parameter instanceof NewExpression || parameter instanceof ArrayAccessExpression || parameter instanceof AssignmentExpression || parameter instanceof FunctionReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpPassByRefInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

