/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.messages;

import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.messages.AssignVarResponse;
import com.jetbrains.php.debug.zend.messages.ZendDebugRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class AssignVarRequest
extends ZendDebugRequest<AssignVarResponse> {
    private static final int DEFAULT_DEPTH = 1;
    private final String myVariableName;
    private final String myValue;
    private final int myDepth;
    private final String[] myPath;

    public AssignVarRequest(String variableName, String value, int depth, String[] path) {
        this.myVariableName = variableName;
        this.myValue = value;
        this.myDepth = depth;
        this.myPath = path;
    }

    public AssignVarRequest(String variableName, String value, String[] path) {
        this(variableName, value, 1, path);
    }

    public AssignVarRequest(String[] path, String value) {
        this(path[0], value, new String[path.length - 1]);
        System.arraycopy(path, 1, this.myPath, 0, path.length - 1);
    }

    @Override
    public short getMessageId() {
        return 33;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        ZendDebugUtil.writeString(out, this.myVariableName);
        ZendDebugUtil.writeString(out, this.myValue);
        out.writeInt(this.myDepth);
        out.writeInt(this.myPath.length);
        for (String pathElement : this.myPath) {
            ZendDebugUtil.writeString(out, pathElement);
        }
    }

    @Override
    protected void appendParameters(Map<String, String> parameters) {
        super.appendParameters(parameters);
        AssignVarRequest.appendParameters(parameters, "var_name", this.myVariableName);
        AssignVarRequest.appendParameters(parameters, "value", this.myValue);
        AssignVarRequest.appendParameters(parameters, "depth", this.myDepth);
        AssignVarRequest.appendParameters(parameters, "path", this.myPath);
    }
}

