/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.php.debug.zend.messages.AddBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.AddConditionalBreakpointRequest;
import com.jetbrains.php.debug.zend.messages.AddLineBreakpointRequest;
import com.jetbrains.php.debug.zend.messages.AssignVarResponse;
import com.jetbrains.php.debug.zend.messages.ContinueProcessFileNotification;
import com.jetbrains.php.debug.zend.messages.DeleteAllBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.DeleteBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.EvalResponse;
import com.jetbrains.php.debug.zend.messages.GetCWDResponse;
import com.jetbrains.php.debug.zend.messages.GetCallStackRequest;
import com.jetbrains.php.debug.zend.messages.GetCallStackResponse;
import com.jetbrains.php.debug.zend.messages.GetCallTraceResponse;
import com.jetbrains.php.debug.zend.messages.GetCodeCoverageResponse;
import com.jetbrains.php.debug.zend.messages.GetFileContentFastNotification;
import com.jetbrains.php.debug.zend.messages.GetFileContentNotification;
import com.jetbrains.php.debug.zend.messages.GetProfilerInfoResponse;
import com.jetbrains.php.debug.zend.messages.GetScriptProfilerInfoResponse;
import com.jetbrains.php.debug.zend.messages.GetStackVarResponse;
import com.jetbrains.php.debug.zend.messages.GetVarResponse;
import com.jetbrains.php.debug.zend.messages.GoResponse;
import com.jetbrains.php.debug.zend.messages.HeaderOutputNotification;
import com.jetbrains.php.debug.zend.messages.OutputNotification;
import com.jetbrains.php.debug.zend.messages.PhpErrorNotification;
import com.jetbrains.php.debug.zend.messages.ReadyNotification;
import com.jetbrains.php.debug.zend.messages.ScriptEndNotification;
import com.jetbrains.php.debug.zend.messages.SendFileContentNotification;
import com.jetbrains.php.debug.zend.messages.ServerErrorNotification;
import com.jetbrains.php.debug.zend.messages.SessionCloseNotification;
import com.jetbrains.php.debug.zend.messages.SessionCloseResponse;
import com.jetbrains.php.debug.zend.messages.SessionStartNotification;
import com.jetbrains.php.debug.zend.messages.SetOptionsResponse;
import com.jetbrains.php.debug.zend.messages.SetProtocolResponse;
import com.jetbrains.php.debug.zend.messages.StartProcessFileNotification;
import com.jetbrains.php.debug.zend.messages.StartResponse;
import com.jetbrains.php.debug.zend.messages.StepIntoResponse;
import com.jetbrains.php.debug.zend.messages.StepOutResponse;
import com.jetbrains.php.debug.zend.messages.StepOverResponse;
import com.jetbrains.php.debug.zend.messages.StopResponse;
import com.jetbrains.php.debug.zend.messages.ZendDebugInputMessage;
import com.jetbrains.php.debug.zend.messages.ZendDebugOutputMessage;
import com.jetbrains.php.debug.zend.messages.ZendDebugRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZendDebugUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.debug.zend.ZendDebugUtil");
    private static final String LOCALHOST = "127.0.0.1";
    public static final int PROTOCOL_V1 = 2006040701;
    public static final int PROTOCOL_V3 = 2006040703;
    public static final int PROTOCOL_V5 = 2006040705;
    public static final int PROTOCOL_V9 = 2006040905;
    private static final String[] errorCodeToName = new String[]{"Debug Error", "Debug Warning", "Parsing Error", "Notice", "Fatal Error", "Core Warning", "Compile Error", "Compile Warning", "User Error", "User Warning", "User Notice", "Debug Strict (PHP 5)"};

    private ZendDebugUtil() {
    }

    public static String getErrorName(int code) {
        int index = ZendDebugUtil.getErrorIndex(code);
        if (index < errorCodeToName.length) {
            return errorCodeToName[index];
        }
        return errorCodeToName[3];
    }

    private static int getErrorIndex(int code) {
        return (int)(Math.log(code) / Math.log(2.0));
    }

    public static void writeString(DataOutputStream out, String line) throws IOException {
        byte[] byteArray = line.getBytes();
        out.writeInt(byteArray.length);
        out.write(byteArray);
    }

    public static void writeStringAsBytes(DataOutputStream out, byte[] byteArray) throws IOException {
        out.writeInt(byteArray.length);
        out.write(byteArray);
    }

    @NotNull
    public static String readString(DataInputStream in) throws IOException {
        String string = new String(ZendDebugUtil.readStringAsBytes(in));
        if (string == null) {
            ZendDebugUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String readEncodedString(DataInputStream in, String encoding) throws IOException {
        byte[] byteArray = ZendDebugUtil.readStringAsBytes(in);
        String rv = ZendDebugUtil.getTextFromBytes(byteArray, encoding);
        return rv;
    }

    public static void writeEncodedString(DataOutputStream out, String line, String encoding) throws IOException {
        byte[] byteArray = ZendDebugUtil.getBytesFromText(line, encoding);
        out.writeInt(byteArray.length);
        out.write(byteArray);
    }

    public static byte[] getBytesFromText(String text, String encoding) {
        try {
            return text.getBytes(encoding);
        }
        catch (Exception e) {
            return text.getBytes();
        }
    }

    public static String getTextFromBytes(byte[] theBytes, String encoding) {
        try {
            return new String(theBytes, encoding);
        }
        catch (Exception e) {
            return new String(theBytes);
        }
    }

    public static byte[] readStringAsBytes(DataInputStream in) throws IOException {
        int size = in.readInt();
        assert (size < 524288000);
        byte[] byteArray = new byte[size];
        in.readFully(byteArray);
        return byteArray;
    }

    public static byte[] readPacket(@NotNull DataInputStream inputStream) throws IOException {
        int packetLength;
        if (inputStream == null) {
            ZendDebugUtil.$$$reportNull$$$0(1);
        }
        if ((packetLength = inputStream.readInt()) < 0) {
            throw new IOException("negative packet length");
        }
        if (packetLength > 0x3200000) {
            throw new IOException("cannot accept too long packet: " + packetLength);
        }
        byte[] packet = new byte[packetLength];
        inputStream.readFully(packet);
        return packet;
    }

    @Nullable
    public static ZendDebugInputMessage readMessage(byte[] packet) throws IOException {
        ByteArrayInputStream packetStream = new ByteArrayInputStream(packet);
        DataInputStream dataInputStream = new DataInputStream(packetStream);
        short messageId = dataInputStream.readShort();
        ZendDebugUtil.dumpPacket("message to ide id", packet);
        switch (messageId) {
            case 2002: {
                return new ScriptEndNotification().deserialize(dataInputStream);
            }
            case 2003: {
                return new ReadyNotification().deserialize(dataInputStream);
            }
            case 2004: {
                return new OutputNotification().deserialize(dataInputStream);
            }
            case 2005: {
                return new SessionStartNotification().deserialize(dataInputStream);
            }
            case 2006: {
                return new PhpErrorNotification().deserialize(dataInputStream);
            }
            case 2007: {
                return new ServerErrorNotification().deserialize(dataInputStream);
            }
            case 2008: {
                return new HeaderOutputNotification().deserialize(dataInputStream);
            }
            case 2009: {
                return new StartProcessFileNotification().deserialize(dataInputStream);
            }
            case 1001: {
                return new StartResponse().deserialize(dataInputStream);
            }
            case 1002: {
                return new StopResponse().deserialize(dataInputStream);
            }
            case 1003: {
                return new SessionCloseResponse().deserialize(dataInputStream);
            }
            case 1004: {
                return new SetOptionsResponse().deserialize(dataInputStream);
            }
            case 1011: {
                return new StepIntoResponse().deserialize(dataInputStream);
            }
            case 1012: {
                return new StepOverResponse().deserialize(dataInputStream);
            }
            case 1013: {
                return new StepOutResponse().deserialize(dataInputStream);
            }
            case 1014: {
                return new GoResponse().deserialize(dataInputStream);
            }
            case 1021: {
                return new AddBreakpointResponse().deserialize(dataInputStream);
            }
            case 1022: {
                return new DeleteBreakpointResponse().deserialize(dataInputStream);
            }
            case 1023: {
                return new DeleteAllBreakpointResponse().deserialize(dataInputStream);
            }
            case 1031: {
                return new EvalResponse().deserialize(dataInputStream);
            }
            case 1032: {
                return new GetVarResponse().deserialize(dataInputStream);
            }
            case 1033: {
                return new AssignVarResponse().deserialize(dataInputStream);
            }
            case 1034: {
                return new GetCallStackResponse().deserialize(dataInputStream);
            }
            case 1035: {
                return new GetStackVarResponse().deserialize(dataInputStream);
            }
            case 1036: {
                return new GetCWDResponse().deserialize(dataInputStream);
            }
            case 11000: {
                return new SetProtocolResponse().deserialize(dataInputStream);
            }
            case 10001: {
                return new GetFileContentNotification().deserialize(dataInputStream);
            }
            case 10002: {
                return new GetFileContentFastNotification().deserialize(dataInputStream);
            }
            case 11011: {
                return new GetProfilerInfoResponse().deserialize(dataInputStream);
            }
            case 11012: {
                return new GetScriptProfilerInfoResponse().deserialize(dataInputStream);
            }
            case 11013: {
                return new GetCallTraceResponse().deserialize(dataInputStream);
            }
            case 11014: {
                return new GetCodeCoverageResponse().deserialize(dataInputStream);
            }
        }
        LOG.debug("unknown message of type: " + messageId + " packet length: " + packet.length);
        return null;
    }

    public static void writePacket(@NotNull DataOutputStream outputStream, byte[] packet) throws IOException {
        if (outputStream == null) {
            ZendDebugUtil.$$$reportNull$$$0(2);
        }
        outputStream.writeInt(packet.length);
        outputStream.write(packet);
        outputStream.flush();
    }

    public static void writeMessage(@NotNull DataOutputStream outputStream, @NotNull ZendDebugOutputMessage outputMessage) throws IOException {
        if (outputStream == null) {
            ZendDebugUtil.$$$reportNull$$$0(3);
        }
        if (outputMessage == null) {
            ZendDebugUtil.$$$reportNull$$$0(4);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputMessage.serialize(new DataOutputStream(byteArrayOutputStream));
        byte[] packet = byteArrayOutputStream.toByteArray();
        ZendDebugUtil.writePacket(outputStream, packet);
    }

    @Nullable
    public static ZendDebugOutputMessage parsePacketToDebugger(byte[] packet) throws IOException {
        ByteArrayInputStream packetStream = new ByteArrayInputStream(packet);
        DataInputStream in = new DataInputStream(packetStream);
        short messageId = in.readShort();
        ZendDebugUtil.dumpPacket("message to debugger", packet);
        switch (messageId) {
            case 11001: {
                int param1 = in.readInt();
                int param2 = in.readInt();
                byte[] fileContent = ZendDebugUtil.readStringAsBytes(in);
                String s = new String(fileContent);
                return new SendFileContentNotification(param1, param2, fileContent);
            }
            case 2010: {
                return new ContinueProcessFileNotification();
            }
            case 3: {
                return new SessionCloseNotification();
            }
        }
        ZendDebugRequest request = null;
        int requestId = in.readInt();
        switch (messageId) {
            case 21: {
                short type = in.readShort();
                short lifetime = in.readShort();
                if (type == 2) {
                    request = new AddConditionalBreakpointRequest(lifetime, ZendDebugUtil.readString(in));
                    break;
                }
                if (type != 1) break;
                request = new AddLineBreakpointRequest(ZendDebugUtil.readString(in), in.readInt(), lifetime);
                break;
            }
            case 34: {
                request = new GetCallStackRequest();
            }
        }
        if (request != null) {
            request.setRequestId(requestId);
            return request;
        }
        return null;
    }

    private static void dumpPacket(@NotNull String description, byte[] packet) {
        if (description == null) {
            ZendDebugUtil.$$$reportNull$$$0(5);
        }
        ByteArrayInputStream packetStream = new ByteArrayInputStream(packet);
        DataInputStream in = new DataInputStream(packetStream);
        try {
            short s = in.readShort();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/ZendDebugUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "readString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/ZendDebugUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readPacket";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writePacket";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dumpPacket";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

