/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.model;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.xdebug.dbgp.DbgpUtil;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpExceptionBreak;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbgpProperty
implements TypeInfo {
    private static final String STRING_TYPE = "string";
    private static final String OBJECT_TYPE = "object";
    private static final String ARRAY_TYPE = "array";
    private static final String BOOL_TYPE = "bool";
    private static final String INT_TYPE = "int";
    public static final String RESOURCE_TYPE = "resource";
    public static final String NULL_TYPE = "null";
    public static final String UNINITIALIZED_TYPE = "uninitialized";
    private static final Logger LOG = Logger.getInstance(DbgpProperty.class);
    private static final String ATTR_ENCODING = "encoding";
    private final Value myShortName;
    private final Value myFullName;
    private final String myType;
    private final Value myClassName;
    private final boolean myIsConstant;
    private final boolean myHasChildren;
    private final String myDefaultEncoding;
    private final Value myRawValue;
    private final int myValueSize;
    private final int myChildCount;
    private final String myAddress;
    private final List<DbgpProperty> myLoadedChildren;

    public DbgpProperty(@NotNull Element element) throws IOException {
        Element valueElement;
        if (element == null) {
            DbgpProperty.$$$reportNull$$$0(0);
        }
        this.myLoadedChildren = new ArrayList<DbgpProperty>();
        this.myShortName = DbgpProperty.getExtendedProperty(element, "name");
        this.myFullName = DbgpProperty.getExtendedProperty(element, "fullname");
        this.myType = element.getAttributeValue("type");
        this.myClassName = DbgpProperty.getExtendedProperty(element, "classname");
        this.myIsConstant = DbgpUtil.toBoolean(element.getAttributeValue("constant"));
        this.myHasChildren = DbgpUtil.toBoolean(element.getAttributeValue("children"));
        this.myDefaultEncoding = element.getAttributeValue(ATTR_ENCODING);
        this.myChildCount = StringUtilRt.parseInt((String)element.getAttributeValue("numchildren"), (int)0);
        this.myAddress = element.getAttributeValue("address");
        this.myValueSize = StringUtilRt.parseInt((String)element.getAttributeValue("size"), (int)0);
        String rawValue = element.getText();
        String encoding = this.myDefaultEncoding;
        if (StringUtil.isEmpty((String)rawValue) && (valueElement = element.getChild("value", DbgpUtil.DBGP_NAMESPACE)) != null) {
            rawValue = valueElement.getValue();
            encoding = valueElement.getAttributeValue(ATTR_ENCODING);
        }
        this.myRawValue = new Value(rawValue, encoding == null ? this.myDefaultEncoding : encoding);
        List elements = element.getChildren("property", DbgpUtil.DBGP_NAMESPACE);
        for (Object o : elements) {
            DbgpProperty child = new DbgpProperty((Element)o);
            if ("CLASSNAME".equals(child.getShortName("UTF-8"))) continue;
            this.myLoadedChildren.add(child);
        }
    }

    @Nullable
    private static Value getExtendedProperty(@NotNull Element element, @NotNull String name) {
        Element child;
        String value;
        if (element == null) {
            DbgpProperty.$$$reportNull$$$0(1);
        }
        if (name == null) {
            DbgpProperty.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(value = element.getAttributeValue(name))) && (child = element.getChild(name, DbgpUtil.DBGP_NAMESPACE)) != null) {
            String encoding = child.getAttributeValue(ATTR_ENCODING);
            return new Value(child.getValue(), encoding);
        }
        return new Value(value);
    }

    public DbgpProperty(@NotNull DbgpExceptionBreak exception) {
        if (exception == null) {
            DbgpProperty.$$$reportNull$$$0(3);
        }
        this.myLoadedChildren = new ArrayList<DbgpProperty>();
        this.myFullName = this.myShortName = new Value("Exception");
        this.myType = OBJECT_TYPE;
        this.myClassName = new Value(exception.getExceptionName());
        this.myIsConstant = false;
        this.myHasChildren = true;
        this.myDefaultEncoding = null;
        this.myRawValue = new Value("");
        this.myValueSize = 0;
        this.myAddress = null;
        boolean hasCode = StringUtil.isNotEmpty((String)exception.getCode());
        int n = this.myChildCount = hasCode ? 2 : 1;
        if (hasCode) {
            this.myLoadedChildren.add(new DbgpProperty("code", exception.getCode(), INT_TYPE));
        }
        this.myLoadedChildren.add(new DbgpProperty("message", exception.getMessage(), STRING_TYPE));
    }

    protected DbgpProperty(@NotNull String name, @NotNull String value, @NotNull String type) {
        if (name == null) {
            DbgpProperty.$$$reportNull$$$0(4);
        }
        if (value == null) {
            DbgpProperty.$$$reportNull$$$0(5);
        }
        if (type == null) {
            DbgpProperty.$$$reportNull$$$0(6);
        }
        this.myLoadedChildren = new ArrayList<DbgpProperty>();
        this.myFullName = this.myShortName = new Value(name);
        this.myType = type;
        this.myClassName = null;
        this.myIsConstant = false;
        this.myHasChildren = false;
        this.myDefaultEncoding = "";
        this.myRawValue = new Value(value);
        this.myValueSize = STRING_TYPE.equals(type) ? value.length() : 0;
        this.myChildCount = 0;
        this.myAddress = null;
    }

    public String getShortName(@NotNull String targetEncoding) {
        if (targetEncoding == null) {
            DbgpProperty.$$$reportNull$$$0(7);
        }
        return this.myShortName.getValue(targetEncoding);
    }

    @NotNull
    public String getFullName(@NotNull String targetEncoding) {
        if (targetEncoding == null) {
            DbgpProperty.$$$reportNull$$$0(8);
        }
        String string = this.myFullName.getValue(targetEncoding);
        if (string == null) {
            DbgpProperty.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String getClassName(@NotNull String targetEncoding) {
        if (targetEncoding == null) {
            DbgpProperty.$$$reportNull$$$0(10);
        }
        return this.myClassName.getValue(targetEncoding);
    }

    public boolean isInitialized() {
        return !UNINITIALIZED_TYPE.equals(this.myType);
    }

    @Override
    public boolean isNull() {
        return NULL_TYPE.equals(this.myType);
    }

    @Override
    public boolean isString() {
        return STRING_TYPE.equals(this.myType);
    }

    public boolean isArray() {
        return ARRAY_TYPE.equals(this.myType);
    }

    public boolean isObject() {
        return OBJECT_TYPE.equals(this.myType);
    }

    public boolean isConstant() {
        return this.myIsConstant;
    }

    @Override
    public boolean isBoolean() {
        return BOOL_TYPE.equals(this.myType);
    }

    @Override
    public boolean isNumber() {
        return INT_TYPE.equals(this.myType) || "float".equals(this.myType) || "double".equals(this.myType);
    }

    public boolean isInt() {
        return INT_TYPE.equals(this.myType);
    }

    public boolean isFloat() {
        return "float".equals(this.myType) || "double".equals(this.myType);
    }

    public boolean isResource() {
        return RESOURCE_TYPE.equals(this.myType);
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    public String getEncoding() {
        return this.myDefaultEncoding;
    }

    @NotNull
    public Pair<String, Integer> getLoadedValue(@NotNull String encoding) {
        if (encoding == null) {
            DbgpProperty.$$$reportNull$$$0(11);
        }
        String rawValue = this.myRawValue.myValue;
        if ("base64".equals(this.myRawValue.myEncoding)) {
            Pair pair;
            try {
                byte[] decoded = Base64.getDecoder().decode(rawValue);
                pair = Pair.create((Object)new String(decoded, encoding), (Object)decoded.length);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Throwable)e);
                Pair pair2 = Pair.empty();
                if (pair2 == null) {
                    DbgpProperty.$$$reportNull$$$0(13);
                }
                return pair2;
            }
            if (pair == null) {
                DbgpProperty.$$$reportNull$$$0(12);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)rawValue, (Object)rawValue.length());
        if (pair == null) {
            DbgpProperty.$$$reportNull$$$0(14);
        }
        return pair;
    }

    public int getValueSize() {
        return this.myValueSize;
    }

    public int getChildCount() {
        return this.myChildCount;
    }

    public List<DbgpProperty> getLoadedChildren() {
        return this.myLoadedChildren;
    }

    public String getAddress() {
        return this.myAddress;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEncoding";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTR_ENCODING;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedProperty";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Value {
        @NotNull
        private final String myValue;
        @Nullable
        private final String myEncoding;

        Value(@Nullable String value) {
            this.myValue = StringUtil.notNullize((String)value);
            this.myEncoding = null;
        }

        Value(@Nullable String value, @Nullable String encoding) {
            this.myValue = StringUtil.notNullize((String)value);
            this.myEncoding = encoding;
        }

        @NotNull
        public String getValue(@NotNull String targetEncoding) {
            if (targetEncoding == null) {
                Value.$$$reportNull$$$0(0);
            }
            if (this.myEncoding != null && "base64".equals(this.myEncoding)) {
                String string;
                block6: {
                    byte[] decoded = Base64.getDecoder().decode(this.myValue);
                    try {
                        string = new String(decoded, targetEncoding);
                        if (string != null) break block6;
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Throwable)e);
                        if ("" == null) {
                            Value.$$$reportNull$$$0(2);
                        }
                        return "";
                    }
                    Value.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = this.myValue;
            if (string == null) {
                Value.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetEncoding";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty$Value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/xdebug/dbgp/model/DbgpProperty$Value";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

