/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.util.Producer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugConfigInstruction;
import com.jetbrains.php.debug.listener.PhpDebugExternalConnectionsAccepter;
import com.jetbrains.php.debug.validation.PhpValidateWebServerAction;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDebugConfigInstructionsPanel
extends JPanel {
    private static final Insets DEFAULT_INSETS = JBUI.insetsBottom((int)5);
    private static final String XDEBUG_INSTALLATION = "https://confluence.jetbrains.com/display/PhpStorm/Xdebug+Installation+Guide";
    private static final String ZEND_DEBUG_INSTALL = "https://confluence.jetbrains.com/display/PhpStorm/Zend+Debugger+Installation+Guide";
    private static final String BROWSER_TOOLBAR = "https://confluence.jetbrains.com/display/PhpStorm/Browser+Debugging+Extensions";
    public static final String ZERO_CONFIGURATION_TUTORIAL = "https://confluence.jetbrains.com/display/PhpStorm/Zero-configuration+Web+Application+Debugging+with+Xdebug+and+PhpStorm";

    private PhpDebugConfigInstructionsPanel(@Nullable Producer<PhpServer> serverProducer) {
        super((LayoutManager)new VerticalFlowLayout(0, 0));
        PhpDebugConfigInstruction install = new PhpDebugConfigInstruction();
        install.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.debugger.php.instruction", new Object[0]));
        install.addHyperlink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.xdebug.php.instruction", new Object[0]), XDEBUG_INSTALLATION);
        install.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.php.instruction", new Object[0]));
        install.addHyperlink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.zend.debugger.php.instruction", new Object[0]), ZEND_DEBUG_INSTALL);
        this.addInstruction(install);
        PhpDebugConfigInstruction validation = new PhpDebugConfigInstruction();
        PhpValidateWebServerAction validateAction = new PhpValidateWebServerAction(serverProducer);
        validation.addAction(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.php.validate.action", new Object[0]), validateAction);
        validation.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.php.validate", new Object[0]));
        this.addInstruction(validation, (Insets)JBUI.insets((int)0, (int)10, (int)5, (int)0));
    }

    @NotNull
    public static PhpDebugConfigInstructionsPanel createWebPageDebugInstructions(@NotNull Producer<PhpServer> serverProducer) {
        if (serverProducer == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(0);
        }
        PhpDebugConfigInstructionsPanel instructions = new PhpDebugConfigInstructionsPanel(serverProducer);
        instructions.addInstruction(new PhpDebugConfigInstruction(PhpBundle.message("PhpDebugConfigurable.web.page.listen.for.connections", new Object[0])));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = instructions;
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(1);
        }
        return phpDebugConfigInstructionsPanel;
    }

    @NotNull
    public static PhpDebugConfigInstructionsPanel createRemoteDebugInstructions(@NotNull Producer<PhpServer> serverProduce) {
        if (serverProduce == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(2);
        }
        PhpDebugConfigInstruction startListening = new PhpDebugConfigInstruction(PhpBundle.message("PhpDebugConfigurable.remote.debug.listen.for.connections", new Object[0]));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = PhpDebugConfigInstructionsPanel.createExternalPreConfig(startListening, serverProduce);
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(3);
        }
        return phpDebugConfigInstructionsPanel;
    }

    @NotNull
    public static PhpDebugConfigInstructionsPanel createZeroConfigurationInstructions(@NotNull Project project) {
        if (project == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(4);
        }
        PhpDebugConfigInstruction startListening = new PhpDebugConfigInstruction();
        startListening.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.listen.for.connections", new Object[0]));
        startListening.addAction(new PhpStartListeningPresentation(project).getActionLink());
        PhpDebugConfigInstruction tutorial = new PhpDebugConfigInstruction();
        tutorial.addHyperlink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.tutorial", new Object[0]), ZERO_CONFIGURATION_TUTORIAL);
        PhpDebugConfigInstructionsPanel instructions = PhpDebugConfigInstructionsPanel.createExternalPreConfig(startListening, null);
        instructions.addInstruction(tutorial, (Insets)JBUI.insetsLeft((int)10));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = instructions;
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(5);
        }
        return phpDebugConfigInstructionsPanel;
    }

    @NotNull
    private static PhpDebugConfigInstructionsPanel createExternalPreConfig(@NotNull PhpDebugConfigInstruction startListening, @Nullable Producer<PhpServer> serverProduce) {
        if (startListening == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(6);
        }
        PhpDebugConfigInstructionsPanel instructions = new PhpDebugConfigInstructionsPanel(serverProduce);
        PhpDebugConfigInstruction toolbar = new PhpDebugConfigInstruction();
        toolbar.addLabel(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.toolbar.instruction.label", new Object[0]));
        toolbar.addHyperlink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.install.toolbar.instruction", new Object[0]), BROWSER_TOOLBAR);
        instructions.addInstruction(toolbar);
        instructions.addInstruction(startListening);
        instructions.addInstruction(new PhpDebugConfigInstruction(PhpBundle.message("PhpDebugConfigurable.zero.configuration.start.session", new Object[0])));
        PhpDebugConfigInstructionsPanel phpDebugConfigInstructionsPanel = instructions;
        if (phpDebugConfigInstructionsPanel == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(7);
        }
        return phpDebugConfigInstructionsPanel;
    }

    private void addInstruction(@NotNull PhpDebugConfigInstruction instruction, @NotNull Insets insets) {
        if (instruction == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(8);
        }
        if (insets == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(9);
        }
        instruction.setBorder(IdeBorderFactory.createEmptyBorder((Insets)insets));
        this.add(instruction);
    }

    private void addInstruction(@NotNull PhpDebugConfigInstruction instruction) {
        if (instruction == null) {
            PhpDebugConfigInstructionsPanel.$$$reportNull$$$0(10);
        }
        instruction.setBorder(IdeBorderFactory.createEmptyBorder((Insets)DEFAULT_INSETS));
        this.add(instruction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverProducer";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverProduce";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startListening";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebPageDebugInstructions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteDebugInstructions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createZeroConfigurationInstructions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExternalPreConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWebPageDebugInstructions";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteDebugInstructions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createZeroConfigurationInstructions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExternalPreConfig";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpStartListeningPresentation {
        private final ActionLink myActionLink;

        PhpStartListeningPresentation(@NotNull Project project) {
            if (project == null) {
                PhpStartListeningPresentation.$$$reportNull$$$0(0);
            }
            this.myActionLink = new ActionLink(PhpBundle.message("PhpDebugConfigurable.zero.configuration.listen.for.connections.action", new Object[0]), new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Project project;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((project = e.getProject()) == null) {
                        return;
                    }
                    PhpDebugExternalConnectionsAccepter.getInstance(project).doSwitch();
                    this.updatePresentation(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel$PhpStartListeningPresentation$1", "actionPerformed"));
                }
            });
            this.myActionLink.setBorder((Border)new EmptyBorder((Insets)JBUI.insets((int)0, (int)5, (int)3, (int)0)));
            this.updatePresentation(project);
        }

        @NotNull
        public ActionLink getActionLink() {
            ActionLink actionLink = this.myActionLink;
            if (actionLink == null) {
                PhpStartListeningPresentation.$$$reportNull$$$0(1);
            }
            return actionLink;
        }

        private void updatePresentation(@NotNull Project project) {
            if (project == null) {
                PhpStartListeningPresentation.$$$reportNull$$$0(2);
            }
            if (PhpDebugExternalConnectionsAccepter.getInstance(project).isStarted()) {
                this.myActionLink.setText(PhpBundle.message("PhpDebugConfigurable.zero.configuration.stop.listen.for.connections.action", new Object[0]));
                this.myActionLink.setIcon(PhpIcons.LISTEN_DEBUG_ON);
            } else {
                this.myActionLink.setIcon(PhpIcons.LISTEN_DEBUG_OFF);
                this.myActionLink.setText(PhpBundle.message("PhpDebugConfigurable.zero.configuration.listen.for.connections.action", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel$PhpStartListeningPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/debug/PhpDebugConfigInstructionsPanel$PhpStartListeningPresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionLink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePresentation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

