/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.arrangement;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.arrangement.PhpArrangementInfo;
import com.jetbrains.php.arrangement.PhpElementArrangementEntry;
import com.jetbrains.php.arrangement.PhpElementArrangementEntryBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpArrangementGrouper {
    private static final String NO_NAME = "No name";

    @Nullable
    public static PhpArrangementGrouper createInstance(@NotNull ArrangementGroupingRule rule) {
        ArrangementSettingsToken type;
        if (rule == null) {
            PhpArrangementGrouper.$$$reportNull$$$0(0);
        }
        if (StdArrangementTokens.Grouping.GETTERS_AND_SETTERS.equals((Object)(type = rule.getGroupingType()))) {
            return new PhpGettersAndSettersGrouper();
        }
        if (StdArrangementTokens.Grouping.OVERRIDDEN_METHODS.equals((Object)type)) {
            return new PhpOverriddenMethodGrouper(rule.getOrderType());
        }
        if (StdArrangementTokens.Grouping.DEPENDENT_METHODS.equals((Object)type)) {
            return new PhpMethodDependenciesGrouper(rule.getOrderType());
        }
        return null;
    }

    public abstract void addGroupingDependencies(@NotNull PhpArrangementInfo var1);

    public void registerClass(@NotNull PhpClass clazz, @NotNull PhpElementArrangementEntryBase entry) {
        if (clazz == null) {
            PhpArrangementGrouper.$$$reportNull$$$0(1);
        }
        if (entry == null) {
            PhpArrangementGrouper.$$$reportNull$$$0(2);
        }
    }

    public abstract void registerMethod(@NotNull Method var1, @NotNull PhpElementArrangementEntryBase var2);

    public abstract void registerField(@NotNull Field var1, @NotNull PhpElementArrangementEntryBase var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementGrouper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpGettersAndSettersGrouper
    extends PhpArrangementGrouper {
        private final Set<PhpGetterSetterArrangementInfo> myGetterSetterInfos = new THashSet();

        private PhpGettersAndSettersGrouper() {
        }

        @Override
        public void addGroupingDependencies(@NotNull PhpArrangementInfo info) {
            if (info == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(0);
            }
            for (PhpGetterSetterArrangementInfo getterSetterInfo : this.myGetterSetterInfos) {
                List<PhpElementArrangementEntryBase> entries = info.getEntries((PsiElement[])getterSetterInfo.getGetters());
                entries.addAll(info.getEntries((PsiElement[])getterSetterInfo.getSetters()));
                if (entries.isEmpty()) continue;
                PhpElementArrangementEntryBase entry = entries.get(0);
                for (int i = 1; i < entries.size(); ++i) {
                    PhpElementArrangementEntryBase next = entries.get(i);
                    if (next.canUpdateDependence(entry)) {
                        next.addDependency((ArrangementEntry)entry);
                    }
                    entry = next;
                }
            }
        }

        @Override
        public void registerMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
            if (method == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(1);
            }
            if (entry == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(2);
            }
        }

        @Override
        public void registerField(@NotNull Field field, @NotNull PhpElementArrangementEntryBase entry) {
            if (field == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(3);
            }
            if (entry == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(4);
            }
            PhpAccessorsGenerator accessorsGenerator = new PhpAccessorsGenerator(field);
            Method[] getters = accessorsGenerator.findGetters();
            Method[] setters = accessorsGenerator.findSetters();
            if (getters.length > 0 || setters.length > 0) {
                this.myGetterSetterInfos.add(new PhpGetterSetterArrangementInfo(getters, setters));
            }
        }

        @Override
        public void registerClass(@NotNull PhpClass clazz, @NotNull PhpElementArrangementEntryBase entry) {
            Method setter;
            Method getter;
            if (clazz == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(5);
            }
            if (entry == null) {
                PhpGettersAndSettersGrouper.$$$reportNull$$$0(6);
            }
            if ((getter = clazz.findOwnMethodByName((CharSequence)"__get")) != null && (setter = clazz.findOwnMethodByName((CharSequence)"__set")) != null) {
                this.myGetterSetterInfos.add(new PhpGetterSetterArrangementInfo(new Method[]{getter}, new Method[]{setter}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementGrouper$PhpGettersAndSettersGrouper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGroupingDependencies";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerMethod";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerField";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PhpGetterSetterArrangementInfo {
            private final Method[] myGetters;
            private final Method[] mySetters;

            PhpGetterSetterArrangementInfo(@NotNull Method[] getter, @NotNull Method[] setter) {
                if (getter == null) {
                    PhpGetterSetterArrangementInfo.$$$reportNull$$$0(0);
                }
                if (setter == null) {
                    PhpGetterSetterArrangementInfo.$$$reportNull$$$0(1);
                }
                this.myGetters = getter;
                this.mySetters = setter;
            }

            @NotNull
            public Method[] getGetters() {
                if (this.myGetters == null) {
                    PhpGetterSetterArrangementInfo.$$$reportNull$$$0(2);
                }
                return this.myGetters;
            }

            @NotNull
            public Method[] getSetters() {
                if (this.mySetters == null) {
                    PhpGetterSetterArrangementInfo.$$$reportNull$$$0(3);
                }
                return this.mySetters;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "getter";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "setter";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/arrangement/PhpArrangementGrouper$PhpGettersAndSettersGrouper$PhpGetterSetterArrangementInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementGrouper$PhpGettersAndSettersGrouper$PhpGetterSetterArrangementInfo";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getGetters";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSetters";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class PhpOverriddenMethodGrouper
    extends PhpArrangementGrouper {
        private final MultiMap<String, PhpElementArrangementEntryBase> myOverriddenMethods = new LinkedMultiMap();
        private final ArrangementSettingsToken myOrderType;

        private PhpOverriddenMethodGrouper(ArrangementSettingsToken orderType) {
            this.myOrderType = orderType;
        }

        @Override
        public void addGroupingDependencies(@NotNull PhpArrangementInfo info) {
            if (info == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(0);
            }
            for (Map.Entry overridden : this.myOverriddenMethods.entrySet()) {
                PhpElementArrangementEntryBase previous = null;
                ArrayList<PhpElementArrangementEntryBase> values = new ArrayList<PhpElementArrangementEntryBase>((Collection)overridden.getValue());
                this.sortByType(values);
                for (PhpElementArrangementEntryBase entry : values) {
                    if (entry.canUpdateDependence(previous)) {
                        assert (previous != null);
                        entry.addDependency((ArrangementEntry)previous);
                    }
                    previous = entry;
                }
            }
        }

        @Override
        public void registerMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
            if (method == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(1);
            }
            if (entry == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(2);
            }
            if (StdArrangementTokens.EntryType.METHOD.equals((Object)entry.getType())) {
                this.processOverriddenMethod(method, entry);
            }
        }

        @Override
        public void registerField(@NotNull Field field, @NotNull PhpElementArrangementEntryBase entry) {
            if (field == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(3);
            }
            if (entry == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(4);
            }
        }

        private void sortByType(@NotNull List<PhpElementArrangementEntryBase> entries) {
            if (entries == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(5);
            }
            if (StdArrangementTokens.Order.BY_NAME.equals((Object)this.myOrderType)) {
                Collections.sort(entries, (entry1, entry2) -> {
                    String name2;
                    String name;
                    String string = name = entry1 instanceof PhpElementArrangementEntry ? ((PhpElementArrangementEntry)((Object)entry1)).getName() : PhpArrangementGrouper.NO_NAME;
                    if (name == null) {
                        return -1;
                    }
                    String string2 = name2 = entry2 instanceof PhpElementArrangementEntry ? ((PhpElementArrangementEntry)((Object)entry2)).getName() : PhpArrangementGrouper.NO_NAME;
                    assert (name2 != null);
                    return name.compareTo(name2);
                });
            }
        }

        private void processOverriddenMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
            if (method == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(6);
            }
            if (entry == null) {
                PhpOverriddenMethodGrouper.$$$reportNull$$$0(7);
            }
            if (!method.isPhysical()) {
                return;
            }
            Ref supperClassNameRef = new Ref(null);
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (classMember, subClass, baseClass) -> {
                supperClassNameRef.set((Object)baseClass.getFQN());
                return false;
            });
            if (!supperClassNameRef.isNull()) {
                this.myOverriddenMethods.putValue(supperClassNameRef.get(), (Object)entry);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entries";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementGrouper$PhpOverriddenMethodGrouper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGroupingDependencies";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerMethod";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerField";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortByType";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processOverriddenMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpMethodDependenciesGrouper
    extends PhpArrangementGrouper {
        private final MultiMap<PsiElement, PsiElement> myDependencies = new LinkedMultiMap();
        private final Set<PsiElement> myDependenciesRoots = new LinkedHashSet<PsiElement>();
        private final MultiMap<PhpElementArrangementEntryBase, PhpElementArrangementEntryBase> myDependencyEntries = new MultiMap();
        private final List<PhpElementArrangementEntryBase> myDependencyEntryRoots = new ArrayList<PhpElementArrangementEntryBase>();
        private final ArrangementSettingsToken myOrderType;
        private boolean myRebuildDependencies = false;

        private PhpMethodDependenciesGrouper(ArrangementSettingsToken orderType) {
            this.myOrderType = orderType;
        }

        @Override
        public void addGroupingDependencies(@NotNull PhpArrangementInfo info) {
            block4: {
                block3: {
                    if (info == null) {
                        PhpMethodDependenciesGrouper.$$$reportNull$$$0(0);
                    }
                    if (!StdArrangementTokens.Order.DEPTH_FIRST.equals((Object)this.myOrderType)) break block3;
                    for (PhpElementArrangementEntryBase root : this.getDependencyRoots(info)) {
                        this.setupDepthFirstDependency(info, root);
                    }
                    break block4;
                }
                if (!StdArrangementTokens.Order.BREADTH_FIRST.equals((Object)this.myOrderType)) break block4;
                for (PhpElementArrangementEntryBase root : this.getDependencyRoots(info)) {
                    this.setupBreadthFirstDependency(info, root);
                }
            }
        }

        public List<PhpElementArrangementEntryBase> getDependencyRoots(@NotNull PhpArrangementInfo info) {
            if (info == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(1);
            }
            if (this.myRebuildDependencies) {
                this.rebuildDependencies(info);
            }
            return this.myDependencyEntryRoots;
        }

        public Collection<PhpElementArrangementEntryBase> getDependencies(@NotNull PhpArrangementInfo info, @NotNull PhpElementArrangementEntryBase entry) {
            if (info == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(2);
            }
            if (entry == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(3);
            }
            if (this.myRebuildDependencies) {
                this.rebuildDependencies(info);
            }
            return this.myDependencyEntries.get((Object)entry);
        }

        private void rebuildDependencies(@NotNull PhpArrangementInfo info) {
            if (info == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(4);
            }
            this.myDependencyEntries.clear();
            this.myDependencyEntryRoots.clear();
            for (Map.Entry element : this.myDependencies.entrySet()) {
                PhpElementArrangementEntryBase rootEntry = info.getEntry((PsiElement)element.getKey());
                if (rootEntry == null) continue;
                List<PhpElementArrangementEntryBase> entries = this.convertElementsToEntries(info, (PsiElement)element.getKey());
                this.myDependencyEntries.put((Object)rootEntry, entries);
                if (!this.myDependenciesRoots.contains(element.getKey())) continue;
                this.myDependencyEntryRoots.add(rootEntry);
            }
            this.myRebuildDependencies = false;
        }

        private List<PhpElementArrangementEntryBase> convertElementsToEntries(@NotNull PhpArrangementInfo info, @NotNull PsiElement root) {
            if (info == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(5);
            }
            if (root == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(6);
            }
            ArrayList<PhpElementArrangementEntryBase> entries = new ArrayList<PhpElementArrangementEntryBase>();
            for (PsiElement element : this.myDependencies.get((Object)root)) {
                PhpElementArrangementEntryBase entry = info.getEntry(element);
                if (entry == null) continue;
                entries.add(entry);
            }
            return entries;
        }

        private PhpElementArrangementEntryBase setupDepthFirstDependency(@NotNull PhpArrangementInfo info, @NotNull PhpElementArrangementEntryBase entry) {
            if (info == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(7);
            }
            if (entry == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(8);
            }
            PhpElementArrangementEntryBase previous = entry;
            for (PhpElementArrangementEntryBase current : this.getDependencies(info, entry)) {
                if (!current.canUpdateDependence(previous) || PhpMethodDependenciesGrouper.hasCircularDependency(current, previous)) continue;
                current.addDependency((ArrangementEntry)previous);
                previous = this.setupDepthFirstDependency(info, current);
            }
            return previous;
        }

        private void setupBreadthFirstDependency(@NotNull PhpArrangementInfo info, @NotNull PhpElementArrangementEntryBase entry) {
            if (info == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(9);
            }
            if (entry == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(10);
            }
            PhpElementArrangementEntryBase previous = entry;
            ArrayDeque<PhpElementArrangementEntryBase> toProcess = new ArrayDeque<PhpElementArrangementEntryBase>();
            toProcess.add(entry);
            while (!toProcess.isEmpty()) {
                PhpElementArrangementEntryBase current = (PhpElementArrangementEntryBase)((Object)toProcess.removeFirst());
                for (PhpElementArrangementEntryBase dependency : this.getDependencies(info, current)) {
                    if (!dependency.canUpdateDependence(previous) || PhpMethodDependenciesGrouper.hasCircularDependency(dependency, previous)) continue;
                    dependency.addDependency((ArrangementEntry)previous);
                    toProcess.addLast(dependency);
                    previous = dependency;
                }
            }
        }

        private static boolean hasCircularDependency(@NotNull PhpElementArrangementEntryBase current, @Nullable PhpElementArrangementEntryBase previous) {
            List dependencies;
            if (current == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(11);
            }
            List list = dependencies = previous == null ? null : previous.getDependencies();
            if (dependencies != null) {
                for (ArrangementEntry entry : dependencies) {
                    if (entry != current && !PhpMethodDependenciesGrouper.hasCircularDependency(current, (PhpElementArrangementEntry)entry)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void registerMethod(@NotNull Method method, @NotNull PhpElementArrangementEntryBase entry) {
            if (method == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(12);
            }
            if (entry == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(13);
            }
            this.processMethodDependencies(method);
        }

        @Override
        public void registerField(@NotNull Field field, @NotNull PhpElementArrangementEntryBase entry) {
            if (field == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(14);
            }
            if (entry == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(15);
            }
        }

        private void processMethodDependencies(final @NotNull Method method) {
            String fqn;
            if (method == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(16);
            }
            final Project project = method.getProject();
            PhpClass clazz = method.getContainingClass();
            String string = fqn = clazz == null ? null : clazz.getFQN();
            if (fqn != null) {
                final ArrayList dependent = new ArrayList();
                method.acceptChildren((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                    public void visitPhpMethodReference(MethodReference reference) {
                        PhpClass containingClass;
                        PsiElement element;
                        if (!DumbService.isDumb((Project)project) && (element = reference.resolve()) instanceof Method && !method.equals(element) && (containingClass = ((Method)element).getContainingClass()) != null && PhpLangUtil.equalsClassNames(fqn, containingClass.getFQN())) {
                            dependent.add(element);
                        }
                        super.visitPhpMethodReference(reference);
                    }
                });
                this.myRebuildDependencies = true;
                this.myDependencies.putValues((Object)method, dependent);
                if (this.shouldBeDependenceRoot(method)) {
                    this.myDependenciesRoots.removeAll(dependent);
                    this.myDependenciesRoots.add((PsiElement)method);
                }
            }
        }

        private boolean shouldBeDependenceRoot(@NotNull Method method) {
            if (method == null) {
                PhpMethodDependenciesGrouper.$$$reportNull$$$0(17);
            }
            for (PsiElement dependence : this.myDependencies.values()) {
                if (!dependence.equals(method)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: 
                case 8: 
                case 10: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 12: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementGrouper$PhpMethodDependenciesGrouper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGroupingDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDependencyRoots";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDependencies";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rebuildDependencies";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convertElementsToEntries";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupDepthFirstDependency";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setupBreadthFirstDependency";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCircularDependency";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerMethod";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerField";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processMethodDependencies";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldBeDependenceRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

