/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities.metadata.stubs;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.angular2.entities.metadata.psi.Angular2MetadataClassBase;
import org.angular2.entities.metadata.stubs.Angular2MetadataClassStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataComponentStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataDirectiveStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataElementStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataPipeStub;
import org.angular2.entities.metadata.stubs.Angular2MetadataReferenceStub;
import org.angular2.lang.metadata.MetadataUtils;
import org.angular2.lang.metadata.psi.MetadataElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2MetadataClassStubBase<Psi extends Angular2MetadataClassBase>
extends Angular2MetadataElementStub<Psi> {
    private static final String EXTENDS_MEMBER = "#ext";
    private static final AtomicNotNullLazyValue<Map<String, EntityFactory>> ENTITY_FACTORIES = new AtomicNotNullLazyValue<Map<String, EntityFactory>>(){

        @NotNull
        protected Map<String, EntityFactory> compute() {
            Map map = ContainerUtil.immutableMapBuilder().put((Object)"Pipe", Angular2MetadataPipeStub::createPipeStub).put((Object)"Component", Angular2MetadataComponentStub::createComponentStub).put((Object)"Directive", Angular2MetadataDirectiveStub::createDirectiveStub).build();
            if (map == null) {
                1.$$$reportNull$$$0(0);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angular2/entities/metadata/stubs/Angular2MetadataClassStubBase$1", "compute"));
        }
    };
    private static final BooleanStructureElement IS_TEMPLATE_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(Angular2MetadataElementStub.FLAGS_STRUCTURE, new FlagsStructureElement[]{IS_TEMPLATE_FLAG});
    protected final Map<String, String> myInputMappings;
    protected final Map<String, String> myOutputMappings;

    private static Map<String, EntityFactory> getEntityFactories() {
        return (Map)ENTITY_FACTORIES.getValue();
    }

    public static Angular2MetadataClassStubBase<?> createClassStub(@Nullable String memberName, @NotNull JsonValue source, @Nullable StubElement parent) {
        if (source == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(0);
        }
        return Angular2MetadataClassStubBase.streamDecorators((JsonObject)source).map(pair -> {
            if (source == null) {
                Angular2MetadataClassStubBase.$$$reportNull$$$0(8);
            }
            return (Angular2MetadataClassStubBase)((Object)((Object)ObjectUtils.doIfNotNull((Object)Angular2MetadataClassStubBase.getEntityFactories().get(pair.first), factory -> {
                if (source == null) {
                    Angular2MetadataClassStubBase.$$$reportNull$$$0(9);
                }
                return factory.create(memberName, parent, (JsonObject)source, (JsonObject)pair.second);
            })));
        }).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            if (source == null) {
                Angular2MetadataClassStubBase.$$$reportNull$$$0(7);
            }
            return new Angular2MetadataClassStub(memberName, source, parent);
        });
    }

    public Angular2MetadataClassStubBase(@Nullable String memberName, @Nullable StubElement parent, @Nullable JsonObject source, @NotNull MetadataElementType elementType) {
        if (elementType == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(1);
        }
        super(memberName, parent, elementType);
        if (source == null) {
            this.myInputMappings = Collections.emptyMap();
            this.myOutputMappings = Collections.emptyMap();
            return;
        }
        this.readTemplateFlag(source);
        JsonObject extendsClass = MetadataUtils.getPropertyValue(source.findProperty("extends"), JsonObject.class);
        if (extendsClass != null) {
            Angular2MetadataReferenceStub.createReferenceStub(EXTENDS_MEMBER, (JsonValue)extendsClass, (StubElement)this);
        }
        this.myOutputMappings = new HashMap<String, String>();
        this.myInputMappings = new HashMap<String, String>();
        MetadataUtils.streamObjectProperty(source.findProperty("members")).forEach(this::loadMember);
    }

    public Angular2MetadataClassStubBase(@NotNull StubInputStream stream, @Nullable StubElement parent, @NotNull MetadataElementType elementType) throws IOException {
        if (stream == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(2);
        }
        if (elementType == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(3);
        }
        super(stream, parent, elementType);
        this.myInputMappings = Angular2MetadataClassStubBase.readStringMap(stream);
        this.myOutputMappings = Angular2MetadataClassStubBase.readStringMap(stream);
    }

    @Nullable
    public String getClassName() {
        return this.getMemberName();
    }

    public Angular2MetadataReferenceStub getExtendsReference() {
        return this.getChildrenStubs().stream().filter(child -> child instanceof Angular2MetadataReferenceStub && EXTENDS_MEMBER.equals(((Angular2MetadataReferenceStub)((Object)child)).getMemberName())).findFirst().orElse(null);
    }

    public Map<String, String> getInputMappings() {
        return Collections.unmodifiableMap(this.myInputMappings);
    }

    public Map<String, String> getOutputMappings() {
        return Collections.unmodifiableMap(this.myOutputMappings);
    }

    public boolean isTemplate() {
        return (Boolean)this.readFlag(IS_TEMPLATE_FLAG);
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(4);
        }
        super.serialize(stream);
        Angular2MetadataClassStubBase.writeStringMap(this.myInputMappings, stream);
        Angular2MetadataClassStubBase.writeStringMap(this.myOutputMappings, stream);
    }

    @Override
    protected FlagsStructure getFlagsStructure() {
        return FLAGS_STRUCTURE;
    }

    private void readTemplateFlag(JsonObject source) {
        JsonObject members = (JsonObject)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)source.findProperty("members"), JsonProperty::getValue), JsonObject.class);
        JsonProperty constructor = members != null ? members.findProperty("__ctor__") : null;
        this.writeFlag(IS_TEMPLATE_FLAG, constructor != null && constructor.getText().contains("TemplateRef"));
    }

    private void loadMember(JsonProperty property) {
        String name = property.getName();
        JsonArray val = (JsonArray)ObjectUtils.tryCast((Object)property.getValue(), JsonArray.class);
        if (val == null || val.getValueList().size() != 1) {
            return;
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast(val.getValueList().get(0), JsonObject.class);
        if (obj == null) {
            return;
        }
        if (!"property".equals(MetadataUtils.readStringPropertyValue(obj.findProperty("__symbolic")))) {
            return;
        }
        Angular2MetadataClassStubBase.streamDecorators(obj).forEach(dec -> {
            if ("Input".equals(dec.first)) {
                Angular2MetadataClassStubBase.addBindingMapping(name, this.myInputMappings, Angular2MetadataClassStubBase.getDecoratorInitializer((JsonObject)dec.second, JsonStringLiteral.class));
            } else if ("Output".equals(dec.first)) {
                Angular2MetadataClassStubBase.addBindingMapping(name, this.myOutputMappings, Angular2MetadataClassStubBase.getDecoratorInitializer((JsonObject)dec.second, JsonStringLiteral.class));
            }
        });
    }

    private static void addBindingMapping(@NotNull String fieldName, @NotNull Map<String, String> mappings, @Nullable JsonStringLiteral initializer) {
        if (fieldName == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(5);
        }
        if (mappings == null) {
            Angular2MetadataClassStubBase.$$$reportNull$$$0(6);
        }
        String bindingName = initializer != null ? initializer.getValue() : fieldName;
        mappings.put(fieldName, bindingName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        objectArray2[1] = "org/angular2/entities/metadata/stubs/Angular2MetadataClassStubBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createClassStub";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addBindingMapping";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createClassStub$2";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createClassStub$1";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface EntityFactory {
        @Nullable
        public Angular2MetadataClassStubBase create(@Nullable String var1, @Nullable StubElement var2, @NotNull JsonObject var3, @NotNull JsonObject var4);
    }
}

