/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.elements.TwigTag;
import com.jetbrains.twig.parser.TwigBlockStatements;
import com.jetbrains.twig.parser.TwigTagParsingData;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwigPsiBuilder
implements TwigElementTypes {
    private final PsiBuilder myBuilder;
    private final Stack<TwigTagParsingData> myTagNamesStack = new Stack();
    private final Stack<PsiBuilder.Marker> myMarkers = new Stack();
    private static final HashMap<String, IElementType> TAG_NAME_TO_TYPE_MAP = new HashMap(TAGS.getTypes().length);

    public TwigPsiBuilder(PsiBuilder builder) {
        this.myBuilder = builder;
    }

    ASTNode buildPsiTree(IElementType root) {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        this.myBuilder.setDebugMode(true);
        while (!this.myBuilder.eof()) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.STATEMENT_BLOCK_START) {
                this.parseStatement();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.PRINT_BLOCK_START) {
                this.parsePrintBlock();
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        this.myMarkers.forEach(e -> e.drop());
        marker.done(root);
        return this.myBuilder.getTreeBuilt();
    }

    private void parseStatement() {
        PsiBuilder.Marker statementMarker = this.myBuilder.mark();
        TwigTagParsingData tagData = this.parseTag();
        if (tagData != null) {
            TwigBlockStatements.StatementDefinition statementDefinition = TwigBlockStatements.getStatementDefinitionByStartTag(tagData.getTagType());
            if (statementDefinition != null) {
                if (statementDefinition.mayBeShort() && !tagData.isShort()) {
                    statementMarker.done(statementDefinition.getStatementType());
                } else {
                    this.myMarkers.push((Object)statementMarker);
                    this.myTagNamesStack.push((Object)tagData);
                }
            } else {
                String name = tagData.getName();
                if (!TwigPsiBuilder.isCustomCloseTag(name) && TAGS.contains(tagData.getTagType())) {
                    statementMarker.drop();
                } else if (!TwigPsiBuilder.isCustomCloseTag(name) && !TAGS.contains(tagData.getTagType())) {
                    this.myMarkers.push((Object)statementMarker);
                    this.myTagNamesStack.push((Object)tagData);
                } else if (TwigPsiBuilder.isCustomCloseTag(name) && !TAGS.contains(tagData.getTagType())) {
                    while (!this.myTagNamesStack.empty() && !TwigPsiBuilder.isEndTag(((TwigTagParsingData)this.myTagNamesStack.peek()).getName(), name)) {
                        this.myTagNamesStack.pop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).drop();
                    }
                    if (!this.myTagNamesStack.isEmpty() && TwigPsiBuilder.isEndTag(((TwigTagParsingData)this.myTagNamesStack.peek()).getName(), name)) {
                        this.myTagNamesStack.pop();
                        statementMarker.drop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).done(TWIG_STATEMENT);
                    } else {
                        statementMarker.drop();
                    }
                } else if (TwigPsiBuilder.isCustomCloseTag(name) && TAGS.contains(tagData.getTagType())) {
                    TwigBlockStatements.StatementDefinition definition = this.getDefinition();
                    while (!(this.myTagNamesStack.isEmpty() || definition != null && (definition.endsBeforeTypes.contains(tagData.getTagType()) || definition.endTagTypes.contains(tagData.getTagType())))) {
                        this.myTagNamesStack.pop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).drop();
                        definition = this.getDefinition();
                    }
                    if (!this.myTagNamesStack.isEmpty() && definition.endTagTypes.contains(tagData.getTagType())) {
                        this.myTagNamesStack.pop();
                        statementMarker.drop();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).done(definition.getStatementType());
                    } else if (!this.myTagNamesStack.isEmpty() && definition.endsBeforeTypes.contains(tagData.getTagType())) {
                        this.myTagNamesStack.pop();
                        statementMarker.rollbackTo();
                        ((PsiBuilder.Marker)this.myMarkers.pop()).done(definition.getStatementType());
                    } else {
                        statementMarker.drop();
                    }
                }
            }
        } else {
            statementMarker.drop();
        }
    }

    private static boolean isCustomCloseTag(String name) {
        return name.startsWith("end") && !name.equals("end") && !name.equals("end_");
    }

    @Nullable
    private TwigBlockStatements.StatementDefinition getDefinition() {
        return TwigBlockStatements.getStatementDefinitionByStartTag(this.myTagNamesStack.isEmpty() ? null : ((TwigTagParsingData)this.myTagNamesStack.peek()).getTagType());
    }

    @Nullable
    private TwigTagParsingData parseTag() {
        assert (this.myBuilder.getTokenType() == TwigTokenTypes.STATEMENT_BLOCK_START);
        PsiBuilder.Marker mark = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == TwigTokenTypes.TAG_NAME) {
            String name = this.myBuilder.getTokenText();
            IElementType tagType = TwigPsiBuilder.getTagType(name);
            this.myBuilder.advanceLexer();
            boolean isShortBlock = true;
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.myBuilder.advanceLexer();
            }
            while (this.myBuilder.getTokenType() != TwigTokenTypes.STATEMENT_BLOCK_END && !this.myBuilder.eof()) {
                isShortBlock = false;
                this.myBuilder.advanceLexer();
                if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                    this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                    continue;
                }
                if (this.myBuilder.getTokenType() != TwigTokenTypes.LBRACE_SQ) continue;
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.STATEMENT_BLOCK_END) {
                this.myBuilder.advanceLexer();
            }
            mark.done(tagType);
            return new TwigTagParsingData(tagType, isShortBlock, name);
        }
        mark.error("A block must start with a tag name");
        return null;
    }

    @NotNull
    private static IElementType getTagType(String tokenText) {
        IElementType mappedType = TAG_NAME_TO_TYPE_MAP.get(tokenText);
        IElementType iElementType = mappedType != null ? mappedType : TAG;
        if (iElementType == null) {
            TwigPsiBuilder.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    private void parsePrintBlock() {
        assert (this.myBuilder.getTokenType() == TwigTokenTypes.PRINT_BLOCK_START);
        PsiBuilder.Marker printBlockMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof()) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.PRINT_BLOCK_END) {
                this.myBuilder.advanceLexer();
                break;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.parseMethodFunction();
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_SQ) {
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        printBlockMarker.done(PRINT_BLOCK);
    }

    private void parseMethodFunction() {
        this.parseFunctionCall();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseFunctionCall() {
        IElementType call = FUNCTION_CALL;
        PsiBuilder.Marker functionCallMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE) {
            this.myBuilder.advanceLexer();
        } else {
            if (this.myBuilder.getTokenType() != TwigTokenTypes.DOT) {
                functionCallMarker.drop();
                return;
            }
            this.myBuilder.advanceLexer();
            call = METHOD_CALL;
            if (this.myBuilder.getTokenType() != TwigTokenTypes.IDENTIFIER) {
                functionCallMarker.drop();
                return;
            }
            this.myBuilder.advanceLexer();
            if (this.myBuilder.getTokenType() != TwigTokenTypes.LBRACE) {
                functionCallMarker.drop();
                return;
            }
            this.myBuilder.advanceLexer();
        }
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != TwigTokenTypes.PRINT_BLOCK_END) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.RBRACE) {
                this.myBuilder.advanceLexer();
                functionCallMarker.done(call);
                return;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
                this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_SQ) {
                this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
                continue;
            }
            if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
                this.parseMethodFunction();
                continue;
            }
            this.myBuilder.advanceLexer();
        }
        functionCallMarker.drop();
        this.myBuilder.error("Unclosed function call");
    }

    private void parseParens() {
        PsiBuilder.Marker parensMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != TwigTokenTypes.PRINT_BLOCK_END) {
            if (this.myBuilder.getTokenType() == TwigTokenTypes.RBRACE) {
                this.myBuilder.advanceLexer();
                parensMarker.done(PARENTHESIZED_EXPRESSION);
                return;
            }
            if (this.parseExpr()) continue;
            this.myBuilder.advanceLexer();
        }
        parensMarker.drop();
        this.myBuilder.error("Unclosed literal");
    }

    private void parseLiteral(IElementType type) {
        PsiBuilder.Marker literalMarker = this.myBuilder.mark();
        this.myBuilder.advanceLexer();
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != TwigTokenTypes.PRINT_BLOCK_END && this.myBuilder.getTokenType() != TwigTokenTypes.RBRACE) {
            if (this.myBuilder.getTokenType() == type) {
                this.myBuilder.advanceLexer();
                literalMarker.done(LITERAL);
                return;
            }
            if (this.parseExpr()) continue;
            this.myBuilder.advanceLexer();
        }
        literalMarker.drop();
        this.myBuilder.error("Unclosed literal");
    }

    private boolean parseExpr() {
        if (this.myBuilder.getTokenType() == TwigTokenTypes.IDENTIFIER) {
            this.parseMethodFunction();
            return true;
        }
        if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE) {
            this.parseParens();
            return true;
        }
        if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_CURL) {
            this.parseLiteral(TwigTokenTypes.RBRACE_CURL);
            return true;
        }
        if (this.myBuilder.getTokenType() == TwigTokenTypes.LBRACE_SQ) {
            this.parseLiteral(TwigTokenTypes.RBRACE_SQ);
            return true;
        }
        return false;
    }

    private static boolean isEndTag(String name, String endName) {
        return endName.equals("end" + name) || endName.equals("end_" + name);
    }

    static {
        for (IElementType type : TAGS.getTypes()) {
            if (!(type instanceof TwigTag)) continue;
            TAG_NAME_TO_TYPE_MAP.put(((TwigTag)type).getTagName(), type);
        }
        TAG_NAME_TO_TYPE_MAP.put("from", TwigElementTypes.IMPORT_TAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/twig/parser/TwigPsiBuilder", "getTagType"));
    }
}

