/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.impl.RuleAction;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.impl.rules.ModuleGroupingRule;
import com.intellij.usages.impl.rules.NonCodeUsageGroupingRule;
import com.intellij.usages.impl.rules.UsageScopeGroupingRule;
import com.intellij.usages.impl.rules.UsageTypeGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class UsageGroupingRuleProviderImpl
implements UsageGroupingRuleProvider {
    protected boolean supportsNonCodeRule() {
        return true;
    }

    protected boolean supportsModuleRule() {
        return true;
    }

    protected boolean supportsScopesRule() {
        return true;
    }

    @Override
    @NotNull
    public UsageGroupingRule[] getActiveRules(@NotNull Project project) {
        if (project == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(0);
        }
        UsageGroupingRule[] usageGroupingRuleArray = this.getActiveRules(project, UsageViewSettings.getInstance());
        if (usageGroupingRuleArray == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(1);
        }
        return usageGroupingRuleArray;
    }

    @Override
    @NotNull
    public UsageGroupingRule[] getActiveRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings) {
        if (project == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(2);
        }
        if (usageViewSettings == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(3);
        }
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        if (this.supportsNonCodeRule()) {
            rules.add(new NonCodeUsageGroupingRule(project));
        }
        if (this.supportsScopesRule() && usageViewSettings.isGroupByScope()) {
            rules.add(new UsageScopeGroupingRule());
        }
        if (usageViewSettings.isGroupByUsageType()) {
            rules.add(new UsageTypeGroupingRule());
        }
        if (this.supportsModuleRule() && usageViewSettings.isGroupByModule()) {
            rules.add(new ModuleGroupingRule(project, usageViewSettings.isFlattenModules()));
        }
        if (usageViewSettings.isGroupByPackage()) {
            rules.add(DirectoryGroupingRule.getInstance(project));
        }
        if (usageViewSettings.isGroupByFileStructure()) {
            for (FileStructureGroupRuleProvider ruleProvider : FileStructureGroupRuleProvider.EP_NAME.getExtensionList()) {
                ContainerUtil.addIfNotNull(rules, (Object)ruleProvider.getUsageGroupingRule(project, usageViewSettings));
            }
        } else {
            rules.add(new FileGroupingRule(project));
        }
        UsageGroupingRule[] usageGroupingRuleArray = rules.toArray(UsageGroupingRule.EMPTY_ARRAY);
        if (usageGroupingRuleArray == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(4);
        }
        return usageGroupingRuleArray;
    }

    @Override
    @NotNull
    public AnAction[] createGroupingActions(@NotNull UsageView view) {
        GroupByModuleTypeAction groupByModuleTypeAction;
        if (view == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(5);
        }
        UsageViewImpl impl = (UsageViewImpl)view;
        JComponent component = impl.getComponent();
        GroupByModuleTypeAction groupByModuleTypeAction2 = groupByModuleTypeAction = this.supportsModuleRule() ? new GroupByModuleTypeAction(impl) : null;
        if (groupByModuleTypeAction != null) {
            groupByModuleTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), component, impl);
        }
        GroupByFileStructureAction groupByFileStructureAction = UsageGroupingRuleProviderImpl.createGroupByFileStructureAction(impl);
        GroupByScopeAction groupByScopeAction = this.supportsScopesRule() ? new GroupByScopeAction(impl) : null;
        GroupByPackageAction groupByPackageAction = new GroupByPackageAction(impl);
        groupByPackageAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(80, 128)), component, impl);
        ArrayList result2 = ContainerUtil.newArrayList();
        if (view.getPresentation().isUsageTypeFilteringAvailable()) {
            GroupByUsageTypeAction groupByUsageTypeAction = new GroupByUsageTypeAction(impl);
            groupByUsageTypeAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(84, 128)), component, impl);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByUsageTypeAction);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByScopeAction);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByModuleTypeAction);
            if (this.supportsModuleRule()) {
                result2.add(new FlattenModulesAction(impl));
            }
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByPackageAction);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByFileStructureAction);
        } else {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByScopeAction);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByModuleTypeAction);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByPackageAction);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)groupByFileStructureAction);
        }
        AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            UsageGroupingRuleProviderImpl.$$$reportNull$$$0(6);
        }
        return anActionArray;
    }

    public static GroupByFileStructureAction createGroupByFileStructureAction(UsageViewImpl impl) {
        JComponent component = impl.getComponent();
        GroupByFileStructureAction groupByFileStructureAction = new GroupByFileStructureAction(impl);
        groupByFileStructureAction.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(77, 128)), component, impl);
        return groupByFileStructureAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageGroupingRuleProviderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageViewSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageGroupingRuleProviderImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveRules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActiveRules";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGroupingActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GroupByFileStructureAction
    extends RuleAction {
        private GroupByFileStructureAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.file.structure", new Object[0]), AllIcons.Actions.GroupByMethod);
        }

        @Override
        protected boolean getOptionValue() {
            return this.myView.getUsageViewSettings().isGroupByFileStructure();
        }

        @Override
        protected void setOptionValue(boolean value) {
            this.myView.getUsageViewSettings().setGroupByFileStructure(value);
        }
    }

    private static class GroupByPackageAction
    extends RuleAction {
        private GroupByPackageAction(UsageViewImpl view) {
            super(view, DirectoryGroupingRule.getInstance(view.getProject()).getActionTitle(), AllIcons.Actions.GroupByPackage);
        }

        @Override
        protected boolean getOptionValue() {
            return this.myView.getUsageViewSettings().isGroupByPackage();
        }

        @Override
        protected void setOptionValue(boolean value) {
            this.myView.getUsageViewSettings().setGroupByPackage(value);
        }
    }

    private static class FlattenModulesAction
    extends RuleAction {
        private FlattenModulesAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.flatten.modules", new Object[0]), AllIcons.ObjectBrowser.FlattenModules);
        }

        @Override
        protected boolean getOptionValue() {
            return this.myView.getUsageViewSettings().isFlattenModules();
        }

        @Override
        protected void setOptionValue(boolean value) {
            this.myView.getUsageViewSettings().setFlattenModules(value);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                FlattenModulesAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(this.myView.getUsageViewSettings().isGroupByModule());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/usages/impl/UsageGroupingRuleProviderImpl$FlattenModulesAction", "update"));
        }
    }

    private static class GroupByModuleTypeAction
    extends RuleAction {
        private GroupByModuleTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.module", new Object[0]), AllIcons.Actions.GroupByModule);
        }

        @Override
        protected boolean getOptionValue() {
            return this.myView.getUsageViewSettings().isGroupByModule();
        }

        @Override
        protected void setOptionValue(boolean value) {
            this.myView.getUsageViewSettings().setGroupByModule(value);
        }
    }

    private static class GroupByScopeAction
    extends RuleAction {
        private GroupByScopeAction(UsageViewImpl view) {
            super(view, "Group by test/production", AllIcons.Actions.GroupByTestProduction);
        }

        @Override
        protected boolean getOptionValue() {
            return this.myView.getUsageViewSettings().isGroupByScope();
        }

        @Override
        protected void setOptionValue(boolean value) {
            this.myView.getUsageViewSettings().setGroupByScope(value);
        }
    }

    private static class GroupByUsageTypeAction
    extends RuleAction {
        private GroupByUsageTypeAction(UsageViewImpl view) {
            super(view, UsageViewBundle.message("action.group.by.usage.type", new Object[0]), AllIcons.General.Filter);
        }

        @Override
        protected boolean getOptionValue() {
            return this.myView.getUsageViewSettings().isGroupByUsageType();
        }

        @Override
        protected void setOptionValue(boolean value) {
            this.myView.getUsageViewSettings().setGroupByUsageType(value);
        }
    }
}

