(* This file was generated by Ocsigen Start.
   Feel free to use it, modify it, and redistribute it as you wish. *)

(** Demo for refreshable content *)

[%%shared open Eliom_content.Html]

(* Service for this demo *)
let%server service =
  Eliom_service.create
    ~path:(Eliom_service.Path ["demo-pull-to-refresh"])
    ~meth:(Eliom_service.Get Eliom_parameter.unit) ()

(* Make service available on the client *)
let%client service = ~%service
(* Name for demo menu *)
let%shared name () = [%i18n Demo.S.pull_to_refresh]
(* Class for the page containing this demo (for internal use) *)
let%shared page_class = "os-page-demo-pull"

let%shared page () =
  let counter_sig, set_counter = Eliom_shared.React.S.create 0 in
  let reload =
    [%client
      fun () ->
        let%lwt _ = Js_of_ocaml_lwt.Lwt_js.sleep 1. in
        let n = Eliom_shared.React.S.value ~%counter_sig in
        ~%set_counter (n + 1);
        Lwt.return_true]
  in
  let counter_node_sig =
    Eliom_shared.React.S.map
      [%shared
        fun n ->
          let n = [F.txt @@ string_of_int n] in
          F.p [%i18n Demo.pull_to_refresh_counter ~n]]
      counter_sig
  in
  let content =
    F.div
      ~a:[F.a_class ["demo-pull-to-refresh-content"]]
      [ F.h1 [%i18n Demo.pull_to_refresh]
      ; F.p [%i18n Demo.pull_to_refresh_1]
      ; F.p [%i18n Demo.pull_to_refresh_2]
      ; R.node counter_node_sig ]
  in
  Lwt.return @@ [Ot_pulltorefresh.make ~dragThreshold:15. ~content reload]
