/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.SetLocalSsrcEvent;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation.GoogleCcEstimator;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacketBuilder;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.AbsSendTimeHeaderExtension;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0+H\u0016J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0015J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u0004\u0018\u000102J\u000e\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/RemoteBandwidthEstimator;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;Ljava/time/Clock;)V", "logger", "<set-?>", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "enabled$delegate", "Lkotlin/properties/ReadWriteProperty;", "astExtId", "", "Ljava/lang/Integer;", "bwe", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "getBwe", "()Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator;", "bwe$delegate", "Lkotlin/Lazy;", "ssrcs", "", "", "numRembsCreated", "numPacketsWithoutAbsSendTime", "localSsrc", "handleEvent", "", "event", "Lorg/jitsi/nlj/Event;", "trace", "f", "Lkotlin/Function0;", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "createRemb", "Lorg/jitsi/rtp/rtcp/rtcpfb/payload_specific_fb/RtcpFbRembPacket;", "onRttUpdate", "newRttMs", "", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRemoteBandwidthEstimator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteBandwidthEstimator.kt\norg/jitsi/nlj/transform/node/incoming/RemoteBandwidthEstimator\n+ 2 Delegates.kt\norg/jitsi/utils/DelegatesKt\n+ 3 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,153:1\n28#2:154\n30#2:158\n33#3,3:155\n*S KotlinDebug\n*F\n+ 1 RemoteBandwidthEstimator.kt\norg/jitsi/nlj/transform/node/incoming/RemoteBandwidthEstimator\n*L\n59#1:154\n59#1:158\n59#1:155,3\n*E\n"})
public final class RemoteBandwidthEstimator
extends ObserverNode {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ReadWriteProperty enabled$delegate;
    @Nullable
    private Integer astExtId;
    @NotNull
    private final Lazy bwe$delegate;
    @NotNull
    private final Set<Long> ssrcs;
    private int numRembsCreated;
    private int numPacketsWithoutAbsSendTime;
    private long localSsrc;
    private static final int MAX_SSRCS = 8;

    public RemoteBandwidthEstimator(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super("Remote Bandwidth Estimator");
        this.streamInformationStore = streamInformationStore;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        Boolean initialValue$iv = false;
        boolean $i$f$observableWhenChanged = false;
        Delegates this_$iv$iv = Delegates.INSTANCE;
        boolean $i$f$observable = false;
        this.enabled$delegate = new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ RemoteBandwidthEstimator this$0;
            {
                this.this$0 = remoteBandwidthEstimator;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter(property, "property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty property2 = property;
                boolean bl = false;
                if (!Intrinsics.areEqual(oldValue2, newValue2)) {
                    void newValue3;
                    boolean bl2 = (Boolean)newValue2;
                    ((Boolean)oldValue2).booleanValue();
                    boolean bl3 = false;
                    RemoteBandwidthEstimator.access$getLogger$p(this.this$0).debug(new Supplier((boolean)newValue3){
                        final /* synthetic */ boolean $newValue;
                        {
                            this.$newValue = $newValue;
                        }

                        public final String get() {
                            return "Setting enabled=" + this.$newValue + ".";
                        }
                    });
                }
            }
        };
        this.bwe$delegate = LazyKt.lazy(() -> RemoteBandwidthEstimator.bwe_delegate$lambda$1(diagnosticContext, this));
        Set set = Collections.synchronizedSet(LRUCache.lruSet(8, true));
        Intrinsics.checkNotNullExpressionValue(set, "synchronizedSet(...)");
        this.ssrcs = set;
        this.streamInformationStore.onRtpExtensionMapping(RtpExtensionType.ABS_SEND_TIME, arg_0 -> RemoteBandwidthEstimator._init_$lambda$3(this, arg_0));
        this.streamInformationStore.onRtpPayloadTypesChanged(arg_0 -> RemoteBandwidthEstimator._init_$lambda$4(this, arg_0));
    }

    public /* synthetic */ RemoteBandwidthEstimator(ReadOnlyStreamInformationStore readOnlyStreamInformationStore, Logger logger, DiagnosticContext diagnosticContext, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 4) != 0) {
            diagnosticContext = new DiagnosticContext();
        }
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        this(readOnlyStreamInformationStore, logger, diagnosticContext, clock);
    }

    private final boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setEnabled(boolean bl) {
        this.enabled$delegate.setValue(this, $$delegatedProperties[0], bl);
    }

    private final BandwidthEstimator getBwe() {
        Lazy lazy = this.bwe$delegate;
        return (BandwidthEstimator)lazy.getValue();
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof SetLocalSsrcEvent && ((SetLocalSsrcEvent)event).getMediaType() == MediaType.VIDEO) {
            this.localSsrc = ((SetLocalSsrcEvent)event).getSsrc();
        }
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT", "False positive"})
    protected void observe(@NotNull PacketInfo packetInfo) {
        block7: {
            Integer n;
            block6: {
                Boolean bl;
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                if (!this.getEnabled()) {
                    return;
                }
                n = this.astExtId;
                if (n == null) break block6;
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
                RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(it);
                if (headerExtension != null) {
                    RtpPacket.HeaderExtension ext = headerExtension;
                    boolean bl3 = false;
                    Instant now = this.clock.instant();
                    BandwidthEstimator bandwidthEstimator = this.getBwe();
                    Intrinsics.checkNotNull(now);
                    BandwidthEstimator.processPacketArrival$default(bandwidthEstimator, now, AbsSendTimeHeaderExtension.Companion.getTime(ext), packetInfo.getReceivedTime(), rtpPacket.getSequenceNumber(), DataSizeKt.getBytes(packetInfo.getOriginalLength()), (byte)0, false, 96, null);
                    this.getBwe().feedbackComplete(now);
                    bl = this.ssrcs.add(rtpPacket.getSsrc());
                } else {
                    bl = null;
                }
                n = bl;
                if (bl != null) break block7;
            }
            int n2 = this.numPacketsWithoutAbsSendTime;
            this.numPacketsWithoutAbsSendTime = n2 + 1;
            n = n2;
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u247 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u247.addString("ast_ext_id", String.valueOf(this.astExtId));
        $this$getNodeStats_u24lambda_u247.addBoolean("enabled", this.getEnabled());
        $this$getNodeStats_u24lambda_u247.addNumber("num_rembs_created", this.numRembsCreated);
        $this$getNodeStats_u24lambda_u247.addNumber("num_packets_without_ast", this.numPacketsWithoutAbsSendTime);
        return nodeStatsBlock;
    }

    @Nullable
    public final RtcpFbRembPacket createRemb() {
        if (!this.getEnabled() || this.astExtId == null) {
            return null;
        }
        BandwidthEstimator bandwidthEstimator = this.getBwe();
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        long currentBw = bandwidthEstimator.getCurrentBw-WElJv5I(instant);
        if (Bandwidth.compareTo-_2icLw0(currentBw, BandwidthKt.getBps(0)) < 0) {
            return null;
        }
        int n = this.numRembsCreated;
        this.numRembsCreated = n + 1;
        RtcpHeaderBuilder rtcpHeaderBuilder = new RtcpHeaderBuilder(0, false, 0, 0, 0, this.localSsrc, 31, null);
        long l = currentBw;
        List<Long> list = CollectionsKt.toList((Iterable)this.ssrcs);
        return new RtcpFbRembPacketBuilder(rtcpHeaderBuilder, list, l).build();
    }

    public final void onRttUpdate(double newRttMs) {
        BandwidthEstimator bandwidthEstimator = this.getBwe();
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        Duration duration = Duration.ofNanos((long)(newRttMs * (double)1000000));
        Intrinsics.checkNotNullExpressionValue(duration, "ofNanos(...)");
        bandwidthEstimator.onRttUpdate(instant, duration);
    }

    private static final GoogleCcEstimator bwe_delegate$lambda$1(DiagnosticContext $diagnosticContext, RemoteBandwidthEstimator this$0) {
        Intrinsics.checkNotNullParameter($diagnosticContext, "$diagnosticContext");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return new GoogleCcEstimator($diagnosticContext, this$0.logger);
    }

    private static final String lambda$3$lambda$2(RemoteBandwidthEstimator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Setting abs-send-time extension ID to " + this$0.astExtId;
    }

    private static final Unit _init_$lambda$3(RemoteBandwidthEstimator this$0, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.astExtId = it;
        this$0.logger.debug(() -> RemoteBandwidthEstimator.lambda$3$lambda$2(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(RemoteBandwidthEstimator this$0, Map it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.setEnabled(this$0.streamInformationStore.getSupportsRemb() && !this$0.streamInformationStore.getSupportsTcc());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RemoteBandwidthEstimator $this) {
        return $this.logger;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(RemoteBandwidthEstimator.class, "enabled", "getEnabled()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/RemoteBandwidthEstimator$Companion;", "", "<init>", "()V", "MAX_SSRCS", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

