/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.net.DatagramPacket;
import java.nio.charset.Charset;
import org.ice4j.ice.harvest.GoogleTurnSSLCandidateHarvester;
import org.ice4j.socket.DatagramPacketFilter;

public class HttpDemuxFilter
implements DatagramPacketFilter {
    private static byte[][] REQUEST_METHOD_BYTES;
    private static final char REQUEST_METHOD_MAX_CHAR;
    public static final int REQUEST_METHOD_MAX_LENGTH;
    private static final char REQUEST_METHOD_MIN_CHAR;
    private static String[] REQUEST_METHOD_STRINGS;
    public static final int TLS_MIN_LENGTH = 11;

    @Override
    public boolean accept(DatagramPacket p) {
        int len = p.getLength();
        boolean accept2 = false;
        if (len > 0) {
            boolean tls;
            boolean sslv2;
            boolean http;
            int off;
            byte[] buf = p.getData();
            int b0 = 0xFF & buf[off = p.getOffset()];
            if (b0 == 22) {
                http = false;
                sslv2 = false;
                tls = true;
            } else if (b0 > 128) {
                http = false;
                sslv2 = true;
                tls = false;
            } else {
                http = true;
                sslv2 = false;
                tls = false;
            }
            if (http) {
                if (b0 >= REQUEST_METHOD_MIN_CHAR && b0 <= REQUEST_METHOD_MAX_CHAR && len >= REQUEST_METHOD_MAX_LENGTH + 1) {
                    for (byte[] bytes : REQUEST_METHOD_BYTES) {
                        int length = bytes.length;
                        if (buf[off + length] != 32) continue;
                        boolean equals = true;
                        int i = 1;
                        int j = off + 1;
                        while (i < length) {
                            if (bytes[i] != buf[j]) {
                                equals = false;
                                break;
                            }
                            ++i;
                            ++j;
                        }
                        if (!equals) continue;
                        accept2 = true;
                        break;
                    }
                }
                return accept2;
            }
            if (tls) {
                int minor;
                if (len >= 11 && (0xFF & buf[off + 1]) == 3 && 1 <= (minor = 0xFF & buf[off + 2]) && minor <= 3 && (0xFF & buf[off + 5]) == 1 && (0xFF & buf[off + 9]) == 3 && 1 <= (minor = 0xFF & buf[off + 10]) && minor <= 3) {
                    accept2 = true;
                }
                return accept2;
            }
            if (sslv2) {
                int minor;
                byte[] googleTurnSslTcp = GoogleTurnSSLCandidateHarvester.SSL_CLIENT_HANDSHAKE;
                if (len > 5 && len >= googleTurnSslTcp.length && (0xFF & buf[off + 2]) == 1 && (0xFF & buf[off + 3]) == 3 && 1 <= (minor = 0xFF & buf[off + 4]) && minor <= 3) {
                    boolean equals = true;
                    int i = 0;
                    int iEnd = googleTurnSslTcp.length;
                    int j = off;
                    while (i < iEnd) {
                        if (googleTurnSslTcp[i] != buf[j]) {
                            equals = false;
                            break;
                        }
                        ++i;
                        ++j;
                    }
                    accept2 = !equals;
                }
                return accept2;
            }
        }
        return accept2;
    }

    static {
        REQUEST_METHOD_STRINGS = new String[]{"CONNECT", "DELETE", "GET", "HEAD", "MOVE", "OPTIONS", "PATCH", "POST", "PRI", "PROXY", "PUT", "TRACE"};
        char maxChar = 'A';
        int maxLength = Integer.MIN_VALUE;
        char minChar = 'Z';
        Charset ascii = Charset.forName("US-ASCII");
        REQUEST_METHOD_BYTES = new byte[REQUEST_METHOD_STRINGS.length][];
        for (int i = 0; i < REQUEST_METHOD_STRINGS.length; ++i) {
            String s2 = REQUEST_METHOD_STRINGS[i];
            if (s2 != null && s2.length() != 0) {
                char ch = s2.charAt(0);
                byte[] bytes = s2.getBytes(ascii);
                int length = bytes.length;
                if (maxChar < ch) {
                    maxChar = ch;
                }
                if (maxLength < length) {
                    maxLength = length;
                }
                if (minChar > ch) {
                    minChar = ch;
                }
                HttpDemuxFilter.REQUEST_METHOD_BYTES[i] = bytes;
                continue;
            }
            HttpDemuxFilter.REQUEST_METHOD_BYTES[i] = new byte[0];
        }
        REQUEST_METHOD_MAX_CHAR = maxChar;
        REQUEST_METHOD_MAX_LENGTH = maxLength;
        REQUEST_METHOD_MIN_CHAR = minChar;
    }
}

