/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.diylc.common.ObjectCache;
import org.diylc.common.PCBLayer;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.CreationMethod;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Copper Trace", author="Branislav Stojkovic", category="Connectivity", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="Trace", description="Straight copper trace", zOrder=3.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false)
public class CopperTrace
extends AbstractLeadedComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size THICKNESS = new Size(Double.valueOf(1.0), SizeUnit.mm);
    public static Color COLOR = Color.black;
    private Size thickness = THICKNESS;
    private PCBLayer layer = PCBLayer._1;

    public CopperTrace() {
        this.leadColor = COLOR;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(3));
        g2d.setColor(COLOR);
        g2d.drawLine(1, height - 2, width - 2, 1);
    }

    protected Color getLeadColorForPainting(ComponentState componentState) {
        return componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.getLeadColor();
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty(name="Color")
    public Color getLeadColor() {
        return this.leadColor;
    }

    @EditableProperty(name="Width")
    public Size getThickness() {
        return this.thickness;
    }

    public void setThickness(Size thickness) {
        this.thickness = thickness;
    }

    @EditableProperty
    public PCBLayer getLayer() {
        if (this.layer == null) {
            this.layer = PCBLayer._1;
        }
        return this.layer;
    }

    public void setLayer(PCBLayer layer) {
        this.layer = layer;
    }

    protected int getLeadThickness() {
        return (int)this.getThickness().convertToPixels();
    }

    protected boolean shouldShadeLeads() {
        return false;
    }

    public Color getBodyColor() {
        return super.getBodyColor();
    }

    public Color getBorderColor() {
        return super.getBorderColor();
    }

    public Byte getAlpha() {
        return super.getAlpha();
    }

    public Size getLength() {
        return super.getLength();
    }

    public Size getWidth() {
        return super.getWidth();
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    protected Shape getBodyShape() {
        return null;
    }

    protected Size getDefaultWidth() {
        return null;
    }

    protected Size getDefaultLength() {
        return null;
    }
}

