/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.CardLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import org.igoweb.igoweb.client.CChannel;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.ChatPane;
import org.igoweb.igoweb.client.swing.ClientPanel;
import org.igoweb.igoweb.client.swing.ClientWindow;
import org.igoweb.igoweb.client.swing.CreateRoomWindow;
import org.igoweb.igoweb.client.swing.GameList;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.ResumeMenu;
import org.igoweb.igoweb.client.swing.UserList;
import org.igoweb.igoweb.shared.GameType;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.ArrowIcon;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.GuiUtil;
import org.igoweb.util.swing.SingletonWindow;

public abstract class RoomPanel
extends ClientPanel
implements ActionListener {
    public final UserList userList;
    private final ChatPane output;
    private final JButton newGameBut;
    private final JButton resumeBut = new JButton(Defs.getString(-903340535));
    private final JPanel accessPanel = new JPanel(new CardLayout());
    private JButton editBut = new JButton(Defs.getString(-903340751));
    private SingletonWindow editWin;
    private final JButton helpBut = new JButton(Defs.getString(1436228516));
    private final JLabel title;
    protected final CRoom room;
    private final EventListener roomListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            RoomPanel.this.roomEvent(event);
        }
    };
    protected final Client client;
    private final ClientWindow clientWin;
    private final ResumeMenu resumeMenu;
    private final GameList gameList;

    public RoomPanel(CRoom room, Client client, ClientWindow clientWin, ResumeMenu resumeMenu) {
        this.client = client;
        this.clientWin = clientWin;
        this.resumeMenu = resumeMenu;
        this.setName(room.getName());
        client.objects.put(room, this);
        this.output = new ChatPane(client, room, 100);
        room.addListener(this.roomListener);
        this.resumeBut.setIcon(new ArrowIcon(UIManager.getInt("org.igoweb.fontH"), 1));
        this.resumeBut.setHorizontalTextPosition(2);
        resumeMenu.addTriggerComponent(this.resumeBut);
        this.newGameBut = new JButton(Defs.getString(-903340746));
        if (room.isTournOnly()) {
            this.newGameBut.setEnabled(false);
            this.resumeBut.setEnabled(false);
        } else {
            this.newGameBut.addActionListener(this);
            this.resumeBut.addActionListener(this);
            resumeMenu.addButton(this.resumeBut);
        }
        this.helpBut.addActionListener(this);
        this.room = room;
        this.add("xGrow=t,xSpan=2", this.titlePanel);
        this.title = new JLabel(room.getName(), 2);
        this.titlePanel.add("xGrow=t", this.title);
        Font font = this.title.getFont();
        if (room.isPermanent()) {
            this.title.setFont(font.deriveFont(1));
        }
        this.titlePanel.add("xGrow=f", this.accessPanel);
        this.accessPanel.add("1", new JLabel());
        this.accessPanel.add("2", this.editBut);
        this.titlePanel.add(this.newGameBut);
        this.titlePanel.add(this.resumeBut);
        this.titlePanel.add(this.popBut);
        this.titlePanel.add(this.closeBut);
        this.closeBut.addActionListener(this);
        this.gameList = this.buildGameList(0);
        room.addListener(this.gameList);
        JSplitPane jsp = new JSplitPane(0, true, this.gameList, this.output);
        jsp.setResizeWeight(0.5);
        jsp.setOneTouchExpandable(true);
        this.add("x=0,xGrow=t,yGrow=t,xSpan=1", jsp);
        this.userList = new UserList(client, room.getMembers().values());
        this.add("xGrow=f", this.userList);
        JPanel jp = new JPanel(new GCLayout());
        this.add("x=0,yGrow=f,xSpan=2,xGrow=t", jp);
        jp.add("xGrow=t", this.output.getInput());
        jp.add("xGrow=f", this.helpBut);
        this.descChanged();
        this.syncEditButton();
    }

    private void roomEvent(Event event) {
        switch (event.type) {
            case 12: 
            case 13: 
            case 14: {
                GuiClientUtil.messageReceived(event, this);
                break;
            }
            case 17: {
                if (((CChannel.Chat)event.arg).user == this.client.getMe()) break;
                this.emit(65537);
                break;
            }
            case 16: {
                this.clientWin.removeChat(this);
                this.client.objects.remove(this.room);
                this.resumeMenu.removeButton(this.resumeBut);
                this.room.removeListener(this.roomListener);
                this.room.removeListener(this.gameList);
                break;
            }
            case 80: {
                this.descChanged();
                break;
            }
            case 81: {
                this.syncEditButton();
                break;
            }
            case 19: {
                this.userList.add((User)event.arg);
                break;
            }
            case 20: {
                this.userList.remove((User)event.arg);
                break;
            }
            case 78: {
                this.newGameBut.setEnabled(!this.room.isTournOnly());
                if (this.room.isTournOnly()) {
                    this.resumeMenu.remove(this.resumeBut);
                    this.resumeBut.setEnabled(false);
                } else {
                    this.resumeMenu.add(this.resumeBut);
                }
                this.title.setText(this.room.getName());
            }
        }
    }

    private void syncEditButton() {
        if (this.room.getOwners().contains(this.client.getMe())) {
            ((CardLayout)this.accessPanel.getLayout()).last(this.accessPanel);
            if (this.editWin == null) {
                this.editWin = new SingletonWindow();
                this.editBut.addActionListener(this);
            }
        } else {
            ((CardLayout)this.accessPanel.getLayout()).first(this.accessPanel);
            this.editWin = null;
            this.editBut.removeActionListener(this);
        }
    }

    private void descChanged() {
        String desc = this.room.getDesc();
        if (desc.length() > 0) {
            this.output.append(desc, 1, true);
        }
    }

    public final int countMembers() {
        return this.room.getMembers().size();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.newGameBut) {
            GuiClientUtil.get(this.client).buildChallengeWindow(this.client, this.room, this);
        } else if (src == this.resumeBut) {
            this.resumeMenu.show(this.resumeBut, this.room);
        } else if (src == this.helpBut) {
            GuiUtil.loadHelp("main.html#chatRoom");
        } else if (src == this.closeBut) {
            this.close();
        } else if (src == this.editBut) {
            this.editWin.setWindow(new CreateRoomWindow(this.client, this.room, this));
        }
    }

    public final void remove(String name) {
        this.userList.remove((User)null);
    }

    public void roomChanged() {
        this.title.setText(this.room.getName());
        Font newFont = UIManager.getFont("Label.font");
        if (this.room.isPermanent()) {
            newFont = newFont.deriveFont(1);
        }
        this.title.setFont(newFont);
    }

    @Override
    public boolean closeForTournament() {
        return false;
    }

    @Override
    public void close() {
        this.room.sendUnjoinRequest();
    }

    @Override
    public String getSortKey() {
        return "1 " + this.room.getName();
    }

    protected abstract GameList buildGameList(int var1);

    protected abstract GameType getUploadGameType();
}

