/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StoppableSearchThread
extends AbstractFullDistribZkTestBase.StoppableThread {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CloudSolrClient cloudClient;
    private volatile boolean stop = false;
    protected final AtomicInteger queryFails = new AtomicInteger();
    private String[] QUERIES = new String[]{"to come", "their country", "aid", "co*"};

    public StoppableSearchThread(CloudSolrClient cloudClient) {
        super("StoppableSearchThread");
        this.cloudClient = cloudClient;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Random random = LuceneTestCase.random();
        int numSearches = 0;
        while (!this.stop) {
            ++numSearches;
            try {
                this.cloudClient.query((SolrParams)new SolrQuery(this.QUERIES[random.nextInt(this.QUERIES.length)]));
            }
            catch (Exception e) {
                System.err.println("QUERY REQUEST FAILED:");
                e.printStackTrace();
                if (e instanceof SolrServerException) {
                    System.err.println("ROOT CAUSE:");
                    ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                }
                this.queryFails.incrementAndGet();
            }
            try {
                Thread.sleep(random.nextInt(4000) + 300);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        log.info("num searches done: {} with {} fails", (Object)numSearches, (Object)this.queryFails);
    }

    @Override
    public void safeStop() {
        this.stop = true;
    }

    public int getFails() {
        return this.queryFails.get();
    }
}

