/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.WordIterator;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public class DefaultTokenizer
implements ITokenizer {
    private static Map<String, Token[]> tokenCache = new HashMap<String, Token[]>(5000);
    public static final Token[] EMPTY_TOKENS_LIST = new Token[0];
    public static final String[] EMPTY_STRINGS_LIST = new String[0];

    public DefaultTokenizer() {
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                Map<String, Token[]> map = tokenCache;
                synchronized (map) {
                    tokenCache.clear();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token[] tokenizeWords(String strOrig, ITokenizer.StemmingMode stemmingMode) {
        Token[] result;
        if (StringUtil.isEmpty(strOrig)) {
            return EMPTY_TOKENS_LIST;
        }
        Map<String, Token[]> map = tokenCache;
        synchronized (map) {
            result = tokenCache.get(strOrig);
        }
        if (result != null) {
            return result;
        }
        result = DefaultTokenizer.tokenizeTextNoCache(strOrig, false);
        map = tokenCache;
        synchronized (map) {
            tokenCache.put(strOrig, result);
        }
        return result;
    }

    @Override
    public String[] tokenizeWordsToStrings(String str, ITokenizer.StemmingMode stemmingMode) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY_STRINGS_LIST;
        }
        return DefaultTokenizer.tokenizeTextToStringsNoCache(str, false);
    }

    @Override
    public Token[] tokenizeVerbatim(String strOrig) {
        return DefaultTokenizer.tokenizeTextNoCache(strOrig, true);
    }

    @Override
    public String[] tokenizeVerbatimToStrings(String str) {
        return DefaultTokenizer.tokenizeTextToStringsNoCache(str, true);
    }

    private static Token[] tokenizeTextNoCache(String strOrig, boolean all) {
        if (StringUtil.isEmpty(strOrig)) {
            return EMPTY_TOKENS_LIST;
        }
        ArrayList<Token> tokens = new ArrayList<Token>(64);
        BreakIterator breaker = DefaultTokenizer.getWordBreaker();
        breaker.setText(strOrig);
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            String tokenStr = strOrig.substring(start, end);
            if (all) {
                tokens.add(new Token(tokenStr, start));
            } else {
                int cp;
                boolean word = false;
                for (int i = 0; i < tokenStr.length(); i += Character.charCount(cp)) {
                    cp = tokenStr.codePointAt(i);
                    if (!Character.isLetter(cp)) continue;
                    word = true;
                    break;
                }
                if (word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                    tokens.add(new Token(tokenStr, start));
                }
            }
            start = end;
            end = breaker.next();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    private static String[] tokenizeTextToStringsNoCache(String str, boolean all) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY_STRINGS_LIST;
        }
        ArrayList<String> tokens = new ArrayList<String>(64);
        BreakIterator breaker = DefaultTokenizer.getWordBreaker();
        breaker.setText(str);
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            String tokenStr = str.substring(start, end);
            if (all) {
                tokens.add(tokenStr);
            } else {
                int cp;
                boolean word = false;
                for (int i = 0; i < tokenStr.length(); i += Character.charCount(cp)) {
                    cp = tokenStr.codePointAt(i);
                    if (!Character.isLetter(cp)) continue;
                    word = true;
                    break;
                }
                if (word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                    tokens.add(tokenStr);
                }
            }
            start = end;
            end = breaker.next();
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static BreakIterator getWordBreaker() {
        return new WordIterator();
    }

    public static boolean isContains(Token[] tokensList, Token tokenForCheck) {
        return DefaultTokenizer.search(tokensList, tokenForCheck, 0) != -1;
    }

    private static int search(Token[] haystack, Token needle, int start) {
        for (int i = start; i < haystack.length; ++i) {
            if (!Objects.equals(needle, haystack[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean isContainsAll(Token[] tokensList, Token[] listForFind, boolean notExact) {
        return notExact ? DefaultTokenizer.containsAllInexact(tokensList, listForFind) : DefaultTokenizer.containsAllExact(tokensList, listForFind);
    }

    public static List<Token[]> searchAll(Token[] tokensList, Token[] listForFind, boolean notExact) {
        return notExact ? DefaultTokenizer.searchAllInexact(tokensList, listForFind) : DefaultTokenizer.searchAllExact(tokensList, listForFind);
    }

    private static boolean containsAllInexact(Token[] haystack, Token[] needles) {
        for (Token n : needles) {
            if (DefaultTokenizer.search(haystack, n, 0) != -1) continue;
            return false;
        }
        return true;
    }

    private static List<Token[]> searchAllInexact(Token[] haystack, Token[] needles) {
        ArrayList<Token> result = null;
        for (Token n : needles) {
            boolean found = false;
            int i = 0;
            while ((i = DefaultTokenizer.search(haystack, n, i)) != -1) {
                if (result == null) {
                    result = new ArrayList<Token>();
                }
                found = true;
                if (!DefaultTokenizer.contains(result, haystack[i])) {
                    result.add(haystack[i]);
                }
                ++i;
            }
            if (found) continue;
            return Collections.emptyList();
        }
        if (result.size() < needles.length) {
            return Collections.emptyList();
        }
        ArrayList<Token[]> ret = new ArrayList<Token[]>();
        ret.add(result.toArray(new Token[result.size()]));
        return ret;
    }

    private static boolean contains(List<Token> list, Token token) {
        for (Token tok : list) {
            if (!tok.deepEquals(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAllExact(Token[] haystack, Token[] needles) {
        return DefaultTokenizer.searchExact(haystack, needles, 0) != -1;
    }

    private static List<Token[]> searchAllExact(Token[] haystack, Token[] needles) {
        int i = DefaultTokenizer.searchExact(haystack, needles, 0);
        if (i == -1) {
            return Collections.emptyList();
        }
        ArrayList<Token[]> result = new ArrayList<Token[]>();
        result.add(Arrays.copyOfRange(haystack, i, i + needles.length));
        while ((i = DefaultTokenizer.searchExact(haystack, needles, i + needles.length)) != -1) {
            result.add(Arrays.copyOfRange(haystack, i, i + needles.length));
        }
        return result;
    }

    private static int searchExact(Token[] haystack, Token[] needles, int start) {
        if (needles.length == 0) {
            return -1;
        }
        for (int i = start; i < haystack.length; ++i) {
            if (!StaticUtils.arraysMatchAt(needles, haystack, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[] getSupportedLanguages() {
        return new String[0];
    }
}

