/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public final class ScriptRunner {
    public static final String SCRIPT_GUI_FUNCTION_NAME = "gui";
    public static final String DEFAULT_SCRIPT = "groovy";
    public static final String VAR_CONSOLE = "console";
    public static final String VAR_MAINWINDOW = "mainWindow";
    public static final String VAR_GLOSSARY = "glossary";
    public static final String VAR_CORE = "Core";
    public static final String VAR_EDITOR = "editor";
    public static final String VAR_PROJECT = "project";
    public static final String VAR_RESOURCES = "res";
    public static final ScriptEngineManager MANAGER = new ScriptEngineManager(ScriptRunner.class.getClassLoader());

    private ScriptRunner() {
    }

    public static String executeScript(ScriptItem item, Map<String, Object> additionalBindings) throws IOException, ScriptException {
        return ScriptRunner.executeScript(null, item, additionalBindings);
    }

    public static String executeScript(String script, ScriptItem item, Map<String, Object> additionalBindings) throws IOException, ScriptException {
        ScriptEngine engine;
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        if (additionalBindings != null) {
            bindings.putAll(additionalBindings);
        }
        bindings.put(VAR_RESOURCES, item.getResourceBundle());
        String extension = DEFAULT_SCRIPT;
        if (item.getFile() != null) {
            extension = FilenameUtils.getExtension((String)item.getFileName());
        }
        if ((engine = MANAGER.getEngineByExtension(extension)) == null) {
            engine = MANAGER.getEngineByName(DEFAULT_SCRIPT);
        }
        if (StringUtil.isEmpty(script)) {
            script = item.getText();
        }
        StringBuilder result = new StringBuilder();
        Object eval = ScriptRunner.executeScript(script, engine, bindings);
        if (eval != null) {
            result.append(OStrings.getString("SCW_SCRIPT_RESULT")).append('\n');
            result.append(eval.toString()).append('\n');
        }
        return result.toString();
    }

    public static Object executeScript(String script, ScriptEngine engine, Map<String, Object> additionalBindings) throws ScriptException {
        Bindings bindings = engine.createBindings();
        bindings.put(VAR_PROJECT, (Object)Core.getProject());
        bindings.put(VAR_EDITOR, (Object)Core.getEditor());
        bindings.put(VAR_GLOSSARY, (Object)Core.getGlossary());
        bindings.put(VAR_MAINWINDOW, (Object)Core.getMainWindow());
        bindings.put(VAR_CORE, (Object)Core.class);
        if (additionalBindings != null) {
            bindings.putAll((Map<? extends String, ? extends Object>)additionalBindings);
        }
        engine.setBindings(bindings, 100);
        Object result = engine.eval(script);
        if (engine instanceof Invocable) {
            ScriptRunner.invokeGuiScript((Invocable)((Object)engine));
        }
        return result;
    }

    private static void invokeGuiScript(Invocable engine) throws ScriptException {
        Runnable invoke = () -> {
            try {
                engine.invokeFunction(SCRIPT_GUI_FUNCTION_NAME, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            invoke.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(invoke);
            }
            catch (InvocationTargetException e) {
                if (e.getCause().getCause() instanceof ScriptException) {
                    throw (ScriptException)e.getCause().getCause();
                }
                Log.log(e);
            }
            catch (InterruptedException e) {
                Log.log(e);
            }
        }
    }

    public static List<String> getAvailableScriptExtensions() {
        return MANAGER.getEngineFactories().stream().flatMap(factory -> factory.getExtensions().stream()).collect(Collectors.toList());
    }
}

