/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences.view;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.Core;
import org.omegat.core.statistics.StatisticsSettings;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.gui.preferences.view.TagProcessingOptionsPanel;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;

public class TagProcessingOptionsController
extends BasePreferencesController {
    private TagProcessingOptionsPanel panel;

    @Override
    public JComponent getGui() {
        if (this.panel == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.panel;
    }

    @Override
    public String toString() {
        return OStrings.getString("PREFS_TITLE_TAG_PROCESSING");
    }

    private void initGui() {
        this.panel = new TagProcessingOptionsPanel();
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                TagProcessingOptionsController.this.validate();
                TagProcessingOptionsController.this.checkReloadRequired();
            }
        };
        this.panel.cbCountingProtectedText.addActionListener(e -> this.checkReloadRequired());
        this.panel.removePatternRegExpTF.getDocument().addDocumentListener(docListener);
        this.panel.customPatternRegExpTF.getDocument().addDocumentListener(docListener);
    }

    private void checkReloadRequired() {
        boolean customPatternChanged = this.valueIsDifferent("tagValidation_customPattern", this.panel.customPatternRegExpTF.getText());
        boolean removePatternChanged = this.valueIsDifferent("tagValidation_removePattern", this.panel.removePatternRegExpTF.getText());
        boolean statsHandlingChanged = (StatisticsSettings.isCountingProtectedText() || StatisticsSettings.isCountingCustomTags()) != this.panel.cbCountingProtectedText.isSelected();
        this.setReloadRequired(customPatternChanged || removePatternChanged || statsHandlingChanged);
    }

    @Override
    protected void initFromPrefs() {
        this.panel.noCheckRadio.setSelected(Preferences.isPreferenceDefault("tagValidation_noCheck", true));
        this.panel.simpleCheckRadio.setSelected(Preferences.isPreference("tagValidation_simpleCheck"));
        this.panel.fullCheckRadio.setSelected(Preferences.isPreference("tagValidation_elaborateCheck"));
        this.panel.javaPatternCheckBox.setSelected(Preferences.isPreference("tagValidation_javaMessageFormatSimplePatternCheck"));
        this.panel.cbCountingProtectedText.setSelected(StatisticsSettings.isCountingProtectedText() || StatisticsSettings.isCountingCustomTags());
        if (Preferences.existsPreference("tagValidation_customPattern")) {
            this.panel.customPatternRegExpTF.setText(Preferences.getPreference("tagValidation_customPattern"));
        } else {
            this.panel.customPatternRegExpTF.setText("\\d+");
        }
        this.panel.removePatternRegExpTF.setText(Preferences.getPreference("tagValidation_removePattern"));
        this.panel.looseTagOrderCheckBox.setSelected(Preferences.isPreference("loose_tag_ordering"));
        this.panel.cbTagsValidRequired.setSelected(Preferences.isPreference("tags_valid_required"));
    }

    @Override
    public void restoreDefaults() {
        this.panel.noCheckRadio.setSelected(true);
        this.panel.simpleCheckRadio.setSelected(false);
        this.panel.fullCheckRadio.setSelected(false);
        this.panel.javaPatternCheckBox.setSelected(false);
        this.panel.customPatternRegExpTF.setText("\\d+");
        this.panel.removePatternRegExpTF.setText("");
        this.panel.looseTagOrderCheckBox.setSelected(false);
        this.panel.cbTagsValidRequired.setSelected(false);
        boolean countingProtectedTextDefault = true;
        this.panel.cbCountingProtectedText.setSelected(countingProtectedTextDefault);
    }

    @Override
    public boolean validate() {
        boolean result = true;
        String customPatternMessage = null;
        String removePatternMessage = null;
        try {
            Pattern.compile(this.panel.customPatternRegExpTF.getText());
        }
        catch (PatternSyntaxException e) {
            result = false;
            customPatternMessage = e.getLocalizedMessage();
        }
        try {
            Pattern.compile(this.panel.removePatternRegExpTF.getText());
        }
        catch (PatternSyntaxException e) {
            result = false;
            removePatternMessage = e.getLocalizedMessage();
        }
        this.panel.customPatternWarningTextArea.setText(customPatternMessage);
        this.panel.removePatternWarningTextArea.setText(removePatternMessage);
        return result;
    }

    @Override
    public void persist() {
        Preferences.setPreference("tagValidation_noCheck", this.panel.noCheckRadio.isSelected());
        Preferences.setPreference("tagValidation_simpleCheck", this.panel.simpleCheckRadio.isSelected());
        Preferences.setPreference("tagValidation_elaborateCheck", this.panel.fullCheckRadio.isSelected());
        Preferences.setPreference("tagValidation_javaMessageFormatSimplePatternCheck", this.panel.javaPatternCheckBox.isSelected());
        Preferences.setPreference("tagValidation_customPattern", this.panel.customPatternRegExpTF.getText());
        Preferences.setPreference("tagValidation_removePattern", this.panel.removePatternRegExpTF.getText());
        Preferences.setPreference("loose_tag_ordering", this.panel.looseTagOrderCheckBox.isSelected());
        Preferences.setPreference("tags_valid_required", this.panel.cbTagsValidRequired.isSelected());
        StatisticsSettings.setCountingProtectedText(this.panel.cbCountingProtectedText.isSelected());
        StatisticsSettings.setCountingCustomTags(this.panel.cbCountingProtectedText.isSelected());
        PatternConsts.updatePlaceholderPattern();
        PatternConsts.updateRemovePattern();
        PatternConsts.updateCustomTagPattern();
        SwingUtilities.invokeLater(() -> Core.getEditor().getSettings().updateTagValidationPreferences());
    }
}

