/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.matches;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.DiffDriver;
import org.omegat.core.matching.NearString;
import org.omegat.util.OStrings;
import org.omegat.util.TMXProp;
import org.omegat.util.VarExpansion;

public class MatchesVarExpansion
extends VarExpansion<NearString> {
    public static final String VAR_ID = "${id}";
    public static final String VAR_SCORE_BASE = "${score}";
    public static final String VAR_SCORE_NOSTEM = "${noStemScore}";
    public static final String VAR_SCORE_ADJUSTED = "${adjustedScore}";
    @Deprecated
    public static final String VAR_CREATION_ID = "${creationId}";
    @Deprecated
    public static final String VAR_CREATION_DATE = "${creationDate}";
    public static final String VAR_INITIAL_CREATION_ID = "${initialCreationId}";
    public static final String VAR_INITIAL_CREATION_DATE = "${initialCreationDate}";
    public static final String VAR_CHANGED_ID = "${changedId}";
    public static final String VAR_CHANGED_DATE = "${changedDate}";
    public static final String VAR_FUZZY_FLAG = "${fuzzyFlag}";
    public static final String VAR_DIFF = "${diff}";
    public static final String VAR_DIFF_REVERSED = "${diffReversed}";
    public static final String VAR_SOURCE_LANGUAGE = "${sourceLanguage}";
    public static final String VAR_TARGET_LANGUAGE = "${targetLanguage}";
    private static final String[] MATCHES_VARIABLES = new String[]{"${id}", "${sourceText}", "${diff}", "${diffReversed}", "${targetText}", "${score}", "${noStemScore}", "${adjustedScore}", "${fileNameOnly}", "${filePath}", "${fileShortPath}", "${initialCreationId}", "${initialCreationDate}", "${changedId}", "${changedDate}", "${fuzzyFlag}", "${sourceLanguage}", "${targetLanguage}"};
    public static final String DEFAULT_TEMPLATE = "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>";
    public static final Pattern PATTERN_SINGLE_PROPERTY = Pattern.compile("@\\{(.+?)\\}");
    public static final Pattern PATTERN_PROPERTY_GROUP = Pattern.compile("@\\[(.+?)\\]\\[(.+?)\\]\\[(.+?)\\]");
    private static final Replacer SOURCE_TEXT_REPLACER = new Replacer(){

        @Override
        public void replace(Result r, NearString match) {
            r.sourcePos = r.text.indexOf("${sourceText}");
            r.text = r.text.replace("${sourceText}", match.source);
        }
    };
    private static final Replacer DIFF_REPLACER = new Replacer(){

        @Override
        public void replace(Result r, NearString match) {
            int diffPos = r.text.indexOf(MatchesVarExpansion.VAR_DIFF);
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            if (diffPos != -1 && ste != null) {
                DiffDriver.Render diffRender = DiffDriver.render(match.source, ste.getSrcText(), true);
                r.diffInfo.put(diffPos, diffRender.formatting);
                if (diffRender.text != null) {
                    r.text = r.text.replace(MatchesVarExpansion.VAR_DIFF, diffRender.text);
                }
            }
        }
    };
    private static final Replacer DIFF_REVERSED_REPLACER = new Replacer(){

        @Override
        public void replace(Result r, NearString match) {
            int diffPos = r.text.indexOf(MatchesVarExpansion.VAR_DIFF_REVERSED);
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            if (diffPos != -1 && ste != null) {
                DiffDriver.Render diffRender = DiffDriver.render(ste.getSrcText(), match.source, true);
                r.diffInfo.put(diffPos, diffRender.formatting);
                if (diffRender.text != null) {
                    r.text = r.text.replace(MatchesVarExpansion.VAR_DIFF_REVERSED, diffRender.text);
                }
            }
        }
    };
    private Map<Integer, Replacer> styledComponents = new TreeMap<Integer, Replacer>();

    public static List<String> getMatchesVariables() {
        return Collections.unmodifiableList(Arrays.asList(MATCHES_VARIABLES));
    }

    public MatchesVarExpansion(String template) {
        super(template);
    }

    public String expandProperties(String localTemplate, List<TMXProp> props) {
        Matcher matcher;
        while ((matcher = PATTERN_SINGLE_PROPERTY.matcher(localTemplate)).find()) {
            String value = this.getPropValue(props, matcher.group(1));
            localTemplate = localTemplate.replace(matcher.group(), value == null ? "" : value);
        }
        while ((matcher = PATTERN_PROPERTY_GROUP.matcher(localTemplate)).find()) {
            String patternStr = matcher.group(1);
            String separator1 = matcher.group(2);
            String separator2 = matcher.group(3);
            separator1 = separator1.replace("\\n", "\n");
            separator2 = separator2.replace("\\n", "\n");
            Pattern pattern = Pattern.compile(patternStr.replace("*", "(.*)").replace("?", "(.)"));
            StringBuilder res = new StringBuilder();
            for (TMXProp me : props) {
                if (!pattern.matcher(me.getType().toString()).matches()) continue;
                res.append(me.getType()).append(separator1).append(me.getValue()).append(separator2);
            }
            if (res.toString().endsWith(separator2)) {
                res.replace(res.toString().lastIndexOf(separator2), res.length(), "");
            }
            localTemplate = localTemplate.replace(matcher.group(), res.toString());
        }
        return localTemplate;
    }

    private String getPropValue(List<TMXProp> props, String type) {
        for (TMXProp me : props) {
            if (!type.equals(me.getType())) continue;
            return me.getValue();
        }
        return null;
    }

    @Override
    public String expandVariables(NearString match) {
        String localTemplate = this.template;
        localTemplate = localTemplate.replace(VAR_INITIAL_CREATION_ID, match.creator == null ? "" : match.creator);
        for (String s : new String[]{VAR_CHANGED_ID, VAR_CREATION_ID}) {
            localTemplate = localTemplate.replace(s, match.changer == null ? "" : match.changer);
        }
        localTemplate = match.creationDate > 0L ? localTemplate.replace(VAR_INITIAL_CREATION_DATE, DateFormat.getInstance().format(new Date(match.creationDate))) : localTemplate.replace(VAR_INITIAL_CREATION_DATE, "");
        for (String s : new String[]{VAR_CHANGED_DATE, VAR_CREATION_DATE}) {
            localTemplate = match.changedDate > 0L ? localTemplate.replace(s, DateFormat.getInstance().format(new Date(match.changedDate))) : localTemplate.replace(s, "");
        }
        localTemplate = localTemplate.replace(VAR_SCORE_BASE, Integer.toString(match.scores[0].score));
        localTemplate = localTemplate.replace(VAR_SCORE_NOSTEM, Integer.toString(match.scores[0].scoreNoStem));
        localTemplate = localTemplate.replace(VAR_SCORE_ADJUSTED, Integer.toString(match.scores[0].adjustedScore));
        localTemplate = localTemplate.replace("${targetText}", match.translation);
        localTemplate = localTemplate.replace(VAR_FUZZY_FLAG, (CharSequence)(match.fuzzyMark ? OStrings.getString("MATCHES_FUZZY_MARK") + " " : ""));
        if (match.props != null) {
            for (TMXProp prop : match.props) {
                if (prop.getType().equals("sourceLanguage")) {
                    localTemplate = localTemplate.replace(VAR_SOURCE_LANGUAGE, prop.getValue());
                    continue;
                }
                if (!prop.getType().equals("targetLanguage")) continue;
                localTemplate = localTemplate.replace(VAR_TARGET_LANGUAGE, prop.getValue());
            }
        }
        localTemplate = localTemplate.replace(VAR_SOURCE_LANGUAGE, "");
        localTemplate = localTemplate.replace(VAR_TARGET_LANGUAGE, "");
        ProjectProperties props = Core.getProject().getProjectProperties();
        if (props != null) {
            localTemplate = this.expandFileNames(localTemplate, match.projs, props.getTMRoot());
        }
        return localTemplate;
    }

    public Result apply(NearString match, int id) {
        Result r = new Result();
        this.styledComponents.clear();
        r.text = this.expandVariables(match);
        r.text = r.text.replace(VAR_ID, Integer.toString(id));
        if (match.props != null) {
            r.text = this.expandProperties(r.text, match.props);
        } else {
            r.text = r.text.replaceAll(PATTERN_SINGLE_PROPERTY.pattern(), "");
            r.text = r.text.replaceAll(PATTERN_PROPERTY_GROUP.pattern(), "");
        }
        this.styledComponents.put(r.text.indexOf("${sourceText}"), SOURCE_TEXT_REPLACER);
        this.styledComponents.put(r.text.indexOf(VAR_DIFF), DIFF_REPLACER);
        this.styledComponents.put(r.text.indexOf(VAR_DIFF_REVERSED), DIFF_REVERSED_REPLACER);
        for (Map.Entry<Integer, Replacer> e : this.styledComponents.entrySet()) {
            e.getValue().replace(r, match);
        }
        return r;
    }

    private static interface Replacer {
        public void replace(Result var1, NearString var2);
    }

    public static class Result {
        public String text = null;
        public int sourcePos = -1;
        public final Map<Integer, List<DiffDriver.TextRun>> diffInfo = new HashMap<Integer, List<DiffDriver.TextRun>>();
    }
}

