/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autocompleter;

import javax.swing.KeyStroke;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.Java8Compat;
import org.omegat.util.Preferences;

public class AutoCompleterKeys {
    public final KeyStroke trigger;
    public final KeyStroke nextView;
    public final KeyStroke prevView;
    public final KeyStroke confirmAndClose;
    public final KeyStroke confirmWithoutClose;
    public final KeyStroke close;
    public final KeyStroke listUp;
    public final KeyStroke listUpEmacs;
    public final KeyStroke listDown;
    public final KeyStroke listDownEmacs;
    public final KeyStroke listPageUp;
    public final KeyStroke listPageDown;
    public final KeyStroke tableUp;
    public final KeyStroke tableUpEmacs;
    public final KeyStroke tableDown;
    public final KeyStroke tableDownEmacs;
    public final KeyStroke tableLeft;
    public final KeyStroke tableLeftEmacs;
    public final KeyStroke tableRight;
    public final KeyStroke tableRightEmacs;
    public final KeyStroke tablePageUp;
    public final KeyStroke tablePageDown;
    public final KeyStroke tableFirst;
    public final KeyStroke tableLast;
    public final KeyStroke tableFirstInRow;
    public final KeyStroke tableLastInRow;

    public AutoCompleterKeys() {
        PropertiesShortcuts shortcuts = PropertiesShortcuts.getEditorShortcuts();
        this.trigger = shortcuts.getKeyStroke("autocompleterTrigger");
        boolean useLeftRight = Preferences.isPreference("ac_switch_views_with_lr");
        int mask = Java8Compat.getMenuShortcutKeyMaskEx();
        this.nextView = useLeftRight ? KeyStroke.getKeyStroke(39, mask) : shortcuts.getKeyStroke("autocompleterNextView");
        this.prevView = useLeftRight ? KeyStroke.getKeyStroke(37, mask) : shortcuts.getKeyStroke("autocompleterPrevView");
        this.confirmAndClose = shortcuts.getKeyStroke("autocompleterConfirmAndClose");
        this.confirmWithoutClose = shortcuts.getKeyStroke("autocompleterConfirmWithoutClose");
        this.close = shortcuts.getKeyStroke("autocompleterClose");
        this.listUp = shortcuts.getKeyStroke("autocompleterListUp");
        this.listUpEmacs = KeyStroke.getKeyStroke("ctrl P");
        this.listDown = shortcuts.getKeyStroke("autocompleterListDown");
        this.listDownEmacs = KeyStroke.getKeyStroke("ctrl N");
        this.listPageUp = shortcuts.getKeyStroke("autocompleterListPageUp");
        this.listPageDown = shortcuts.getKeyStroke("autocompleterListPageDown");
        this.tableUp = shortcuts.getKeyStroke("autocompleterTableUp");
        this.tableUpEmacs = KeyStroke.getKeyStroke("ctrl P");
        this.tableDown = shortcuts.getKeyStroke("autocompleterTableDown");
        this.tableDownEmacs = KeyStroke.getKeyStroke("ctrl N");
        this.tableLeft = shortcuts.getKeyStroke("autocompleterTableLeft");
        this.tableLeftEmacs = KeyStroke.getKeyStroke("ctrl B");
        this.tableRight = shortcuts.getKeyStroke("autocompleterTableRight");
        this.tableRightEmacs = KeyStroke.getKeyStroke("ctrl F");
        this.tablePageUp = shortcuts.getKeyStroke("autocompleterTablePageUp");
        this.tablePageDown = shortcuts.getKeyStroke("autocompleterTablePageDown");
        this.tableFirst = shortcuts.getKeyStroke("autocompleterTableFirst");
        this.tableLast = shortcuts.getKeyStroke("autocompleterTableLast");
        this.tableFirstInRow = shortcuts.getKeyStroke("autocompleterTableFirstInRow");
        this.tableLastInRow = shortcuts.getKeyStroke("autocompleterTableLastInRow");
    }
}

