/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.align;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.loomchild.maligna.coretypes.Alignment;
import org.omegat.gui.align.Util;
import org.omegat.util.Language;

class MutableBead {
    public final float score;
    public final List<String> sourceLines;
    public final List<String> targetLines;
    public boolean enabled;
    public Status status;

    private MutableBead(float score, List<String> sourceLines, List<String> targetLines) {
        this.score = score;
        this.sourceLines = new ArrayList<String>(sourceLines);
        this.targetLines = new ArrayList<String>(targetLines);
        boolean srcEqualsTrg = sourceLines.equals(targetLines);
        this.enabled = !srcEqualsTrg;
        this.status = srcEqualsTrg ? Status.ACCEPTED : Status.DEFAULT;
    }

    MutableBead(Alignment alignment) {
        this(alignment.getScore(), alignment.getSourceSegmentList(), alignment.getTargetSegmentList());
    }

    MutableBead(List<String> sourceLines, List<String> targetLines) {
        this(Float.MAX_VALUE, sourceLines, targetLines);
    }

    MutableBead(String source, String target) {
        this(Arrays.asList(source), Arrays.asList(target));
    }

    MutableBead() {
        this(Collections.emptyList(), Collections.emptyList());
        this.enabled = true;
        this.status = Status.DEFAULT;
    }

    public boolean isBalanced() {
        return this.sourceLines.size() == this.targetLines.size();
    }

    public boolean isEmpty() {
        return this.sourceLines.isEmpty() && this.targetLines.isEmpty();
    }

    static List<Map.Entry<String, String>> beadsToEntries(Language srcLang, Language trgLang, List<MutableBead> beads) {
        return beads.stream().filter(bead -> bead.enabled).map(bead -> {
            String srcOut = bead.sourceLines.isEmpty() ? null : Util.join(srcLang, bead.sourceLines);
            String trgOut = bead.targetLines.isEmpty() ? null : Util.join(trgLang, bead.targetLines);
            return new AbstractMap.SimpleImmutableEntry<String, String>(srcOut, trgOut);
        }).collect(Collectors.toList());
    }

    static double calculateAvgDist(List<MutableBead> beads) {
        return beads.stream().mapToDouble(bead -> bead.score).average().orElse(Double.MAX_VALUE);
    }

    static enum Status {
        DEFAULT,
        ACCEPTED,
        NEEDS_REVIEW;

    }
}

