/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import org.omegat.core.team2.IRemoteRepository2;
import org.omegat.core.team2.impl.FileRepository;
import org.omegat.core.team2.impl.GITRemoteRepository2;
import org.omegat.core.team2.impl.HTTPRemoteRepository;
import org.omegat.core.team2.impl.SVNRemoteRepository2;

public final class RemoteRepositoryFactory {
    private RemoteRepositoryFactory() {
    }

    public static IRemoteRepository2 create(String type) {
        if ("svn".equals(type)) {
            return new SVNRemoteRepository2();
        }
        if ("git".equals(type)) {
            return new GITRemoteRepository2();
        }
        if ("http".equals(type)) {
            return new HTTPRemoteRepository();
        }
        if ("file".equals(type)) {
            return new FileRepository();
        }
        throw new RuntimeException("Unknown repository type: " + type);
    }

    public static String detectRepositoryType(String url) {
        if (url.startsWith("svn")) {
            return "svn";
        }
        if (url.startsWith("git")) {
            return "git";
        }
        if (GITRemoteRepository2.isGitRepository(url)) {
            return "git";
        }
        if (SVNRemoteRepository2.isSVNRepository(url)) {
            return "svn";
        }
        return null;
    }
}

